/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.matchers.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SourceTransforms {
    public static Map<String, List<Object>> normalize(Map<String, Object> documentMap, Map<String, Map<String, Object>> mappingLookup) {
        TreeMap<String, List<Object>> flattened = new TreeMap<String, List<Object>>();
        SourceTransforms.descend(null, documentMap, flattened, mappingLookup);
        return flattened;
    }

    public static <T> List<T> normalizeValues(List<T> values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return SourceTransforms.normalizeValues(values, Function.identity());
    }

    public static <T, U> List<U> normalizeValues(List<T> values, Function<T, U> transform) {
        if (values == null) {
            return Collections.emptyList();
        }
        return values.stream().filter(v -> v != null && !Objects.equals(v, "null")).map(transform).distinct().collect(Collectors.toList());
    }

    private static void descend(String pathFromRoot, Map<String, Object> currentLevel, Map<String, List<Object>> flattened, Map<String, Map<String, Object>> mappingLookup) {
        for (Map.Entry<String, Object> entry : currentLevel.entrySet()) {
            String pathToCurrentField = pathFromRoot == null ? entry.getKey() : pathFromRoot + "." + entry.getKey();
            Iterator iterator = entry.getValue();
            if (iterator instanceof List) {
                List list = (List)((Object)iterator);
                for (Object fieldValue : list) {
                    SourceTransforms.handleField(pathToCurrentField, fieldValue, flattened, mappingLookup);
                }
                continue;
            }
            SourceTransforms.handleField(pathToCurrentField, entry.getValue(), flattened, mappingLookup);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void handleField(String pathToCurrentField, Object currentField, Map<String, List<Object>> flattened, Map<String, Map<String, Object>> mappingLookup) {
        Map<String, Object> mapping = mappingLookup.get(pathToCurrentField);
        if (currentField instanceof Map) {
            Map map = (Map)currentField;
            if (mapping == null || mapping.get("type").equals("object") || mapping.get("type").equals("nested")) {
                SourceTransforms.descend(pathToCurrentField, map, flattened, mappingLookup);
                return;
            }
        }
        flattened.computeIfAbsent(pathToCurrentField, k -> new ArrayList()).add(currentField);
    }
}

