/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.datageneration.datasource.DataSource;
import org.elasticsearch.datageneration.datasource.DataSourceHandler;
import org.elasticsearch.datageneration.fields.PredefinedField;

public record DataGeneratorSpecification(DataSource dataSource, int maxFieldCountPerLevel, int maxObjectDepth, int nestedFieldsLimit, boolean fullyDynamicMapping, List<PredefinedField> predefinedFields) {
    public static Builder builder() {
        return new Builder();
    }

    public static DataGeneratorSpecification buildDefault() {
        return DataGeneratorSpecification.builder().build();
    }

    public static class Builder {
        private List<DataSourceHandler> dataSourceHandlers = new ArrayList<DataSourceHandler>();
        private int maxFieldCountPerLevel = 50;
        private int maxObjectDepth = 2;
        private int nestedFieldsLimit = 50;
        private boolean fullyDynamicMapping = false;
        private List<PredefinedField> predefinedFields = new ArrayList<PredefinedField>();

        public Builder withDataSourceHandlers(Collection<DataSourceHandler> handlers) {
            this.dataSourceHandlers.addAll(handlers);
            return this;
        }

        public Builder withMaxFieldCountPerLevel(int maxFieldCountPerLevel) {
            this.maxFieldCountPerLevel = maxFieldCountPerLevel;
            return this;
        }

        public Builder withMaxObjectDepth(int maxObjectDepth) {
            this.maxObjectDepth = maxObjectDepth;
            return this;
        }

        public Builder withNestedFieldsLimit(int nestedFieldsLimit) {
            this.nestedFieldsLimit = nestedFieldsLimit;
            return this;
        }

        public Builder withFullyDynamicMapping(boolean fullyDynamicMapping) {
            this.fullyDynamicMapping = fullyDynamicMapping;
            return this;
        }

        public Builder withPredefinedFields(List<PredefinedField> predefinedFields) {
            this.predefinedFields = predefinedFields;
            return this;
        }

        public DataGeneratorSpecification build() {
            return new DataGeneratorSpecification(new DataSource(this.dataSourceHandlers), this.maxFieldCountPerLevel, this.maxObjectDepth, this.nestedFieldsLimit, this.fullyDynamicMapping, this.predefinedFields);
        }
    }
}

