/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.List;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;

public class JsonLogLine {
    public static final ObjectParser<JsonLogLine, Void> ECS_LOG_LINE = JsonLogLine.createECSParser(true);
    public static final ObjectParser<JsonLogLine, Void> ES_LOG_LINE = JsonLogLine.createESParser(true);
    private String dataset;
    private String timestamp;
    private String level;
    private String component;
    private String clusterName;
    private String nodeName;
    private String clusterUuid;
    private String nodeId;
    private String message;
    private List<String> tags;
    private List<String> stacktrace;

    public String toString() {
        StringBuilder sb = new StringBuilder("JsonLogLine{");
        sb.append("dataset='").append(this.dataset).append('\'');
        sb.append(", timestamp='").append(this.timestamp).append('\'');
        sb.append(", level='").append(this.level).append('\'');
        sb.append(", component='").append(this.component).append('\'');
        sb.append(", clusterName='").append(this.clusterName).append('\'');
        sb.append(", nodeName='").append(this.nodeName).append('\'');
        sb.append(", clusterUuid='").append(this.clusterUuid).append('\'');
        sb.append(", nodeId='").append(this.nodeId).append('\'');
        sb.append(", message='").append(this.message).append('\'');
        sb.append(", tags='").append(this.tags).append('\'');
        sb.append(", stacktrace=").append(this.stacktrace);
        sb.append('}');
        return sb.toString();
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getLevel() {
        return this.level;
    }

    public String getComponent() {
        return this.component;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getClusterUuid() {
        return this.clusterUuid;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<String> stacktrace() {
        return this.stacktrace;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setClusterUuid(String clusterUuid) {
        this.clusterUuid = clusterUuid;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setStacktrace(List<String> stacktrace) {
        this.stacktrace = stacktrace;
    }

    private static ObjectParser<JsonLogLine, Void> createECSParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser("json_log_line", ignoreUnknownFields, JsonLogLine::new);
        parser.declareString(JsonLogLine::setDataset, new ParseField("event.dataset", new String[0]));
        parser.declareString(JsonLogLine::setTimestamp, new ParseField("@timestamp", new String[0]));
        parser.declareString(JsonLogLine::setLevel, new ParseField("log.level", new String[0]));
        parser.declareString(JsonLogLine::setComponent, new ParseField("log.logger", new String[0]));
        parser.declareString(JsonLogLine::setClusterName, new ParseField("elasticsearch.cluster.name", new String[0]));
        parser.declareString(JsonLogLine::setNodeName, new ParseField("elasticsearch.node.name", new String[0]));
        parser.declareString(JsonLogLine::setClusterUuid, new ParseField("elasticsearch.cluster.uuid", new String[0]));
        parser.declareString(JsonLogLine::setNodeId, new ParseField("elasticsearch.node.id", new String[0]));
        parser.declareString(JsonLogLine::setMessage, new ParseField("message", new String[0]));
        parser.declareStringArray(JsonLogLine::setTags, new ParseField("tags", new String[0]));
        parser.declareStringArray(JsonLogLine::setStacktrace, new ParseField("error.stack_trace", new String[0]));
        return parser;
    }

    private static ObjectParser<JsonLogLine, Void> createESParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser("search_template", ignoreUnknownFields, JsonLogLine::new);
        parser.declareString(JsonLogLine::setDataset, new ParseField("type", new String[0]));
        parser.declareString(JsonLogLine::setTimestamp, new ParseField("timestamp", new String[0]));
        parser.declareString(JsonLogLine::setLevel, new ParseField("level", new String[0]));
        parser.declareString(JsonLogLine::setComponent, new ParseField("component", new String[0]));
        parser.declareString(JsonLogLine::setClusterName, new ParseField("cluster.name", new String[0]));
        parser.declareString(JsonLogLine::setNodeName, new ParseField("node.name", new String[0]));
        parser.declareString(JsonLogLine::setClusterUuid, new ParseField("cluster.uuid", new String[0]));
        parser.declareString(JsonLogLine::setNodeId, new ParseField("node.id", new String[0]));
        parser.declareString(JsonLogLine::setMessage, new ParseField("message", new String[0]));
        parser.declareStringArray(JsonLogLine::setStacktrace, new ParseField("stacktrace", new String[0]));
        return parser;
    }
}

