/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ValuedEnumParser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class TextParseNode
implements ParseNode {
    private final String text;
    private static final String NO_STRUCTURED_DATA_MESSAGE = "text does not support structured data";
    private Consumer<Parsable> onBeforeAssignFieldValues;
    private Consumer<Parsable> onAfterAssignFieldValues;

    public TextParseNode(@Nonnull String rawText) {
        Objects.requireNonNull(rawText, "parameter node cannot be null");
        this.text = rawText.startsWith("\"") && rawText.endsWith("\"") ? rawText.substring(1, rawText.length() - 2) : rawText;
    }

    @Override
    @Nullable
    public ParseNode getChildNode(@Nonnull String identifier) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Override
    @Nullable
    public String getStringValue() {
        return this.text;
    }

    @Override
    @Nullable
    public Boolean getBooleanValue() {
        return Boolean.parseBoolean(this.text);
    }

    @Override
    @Nullable
    public Byte getByteValue() {
        return Byte.parseByte(this.text);
    }

    @Override
    @Nullable
    public Short getShortValue() {
        return Short.parseShort(this.text);
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimalValue() {
        return new BigDecimal(this.text);
    }

    @Override
    @Nullable
    public Integer getIntegerValue() {
        return Integer.parseInt(this.text);
    }

    @Override
    @Nullable
    public Float getFloatValue() {
        return Float.valueOf(Float.parseFloat(this.text));
    }

    @Override
    @Nullable
    public Double getDoubleValue() {
        return Double.parseDouble(this.text);
    }

    @Override
    @Nullable
    public Long getLongValue() {
        return Long.parseLong(this.text);
    }

    @Override
    @Nullable
    public UUID getUUIDValue() {
        return UUID.fromString(this.getStringValue());
    }

    @Override
    @Nullable
    public OffsetDateTime getOffsetDateTimeValue() {
        try {
            return OffsetDateTime.parse(this.getStringValue());
        }
        catch (DateTimeParseException ex) {
            try {
                LocalDateTime localDateTime = LocalDateTime.parse(this.getStringValue());
                return localDateTime.atOffset(ZoneOffset.UTC);
            }
            catch (DateTimeParseException ex2) {
                throw ex;
            }
        }
    }

    @Override
    @Nullable
    public LocalDate getLocalDateValue() {
        return LocalDate.parse(this.getStringValue());
    }

    @Override
    @Nullable
    public LocalTime getLocalTimeValue() {
        return LocalTime.parse(this.getStringValue());
    }

    @Override
    @Nullable
    public PeriodAndDuration getPeriodAndDurationValue() {
        return PeriodAndDuration.parse(this.getStringValue());
    }

    @Override
    @Nullable
    public <T> List<T> getCollectionOfPrimitiveValues(@Nonnull Class<T> targetClass) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Override
    @Nullable
    public <T extends Parsable> List<T> getCollectionOfObjectValues(@Nonnull ParsableFactory<T> factory) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Override
    @Nullable
    public <T extends Enum<T>> List<T> getCollectionOfEnumValues(@Nonnull ValuedEnumParser<T> enumParser) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Override
    @Nonnull
    public <T extends Parsable> T getObjectValue(@Nonnull ParsableFactory<T> factory) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Override
    @Nullable
    public <T extends Enum<T>> T getEnumValue(@Nonnull ValuedEnumParser<T> enumParser) {
        String rawValue = this.getStringValue();
        if (rawValue == null || rawValue.isEmpty()) {
            return null;
        }
        return enumParser.forValue(rawValue);
    }

    @Override
    @Nullable
    public <T extends Enum<T>> EnumSet<T> getEnumSetValue(@Nonnull ValuedEnumParser<T> enumParser) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnBeforeAssignFieldValues() {
        return this.onBeforeAssignFieldValues;
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnAfterAssignFieldValues() {
        return this.onAfterAssignFieldValues;
    }

    @Override
    public void setOnBeforeAssignFieldValues(@Nullable Consumer<Parsable> value) {
        this.onBeforeAssignFieldValues = value;
    }

    @Override
    public void setOnAfterAssignFieldValues(@Nullable Consumer<Parsable> value) {
        this.onAfterAssignFieldValues = value;
    }

    @Override
    @Nullable
    public byte[] getByteArrayValue() {
        String base64 = this.getStringValue();
        if (base64 == null || base64.isEmpty()) {
            return null;
        }
        return Base64.getDecoder().decode(base64);
    }
}

