/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.google.gson.stream.JsonWriter;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.ComposedTypeWrapper;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.UntypedArray;
import com.microsoft.kiota.serialization.UntypedBoolean;
import com.microsoft.kiota.serialization.UntypedDecimal;
import com.microsoft.kiota.serialization.UntypedDouble;
import com.microsoft.kiota.serialization.UntypedFloat;
import com.microsoft.kiota.serialization.UntypedInteger;
import com.microsoft.kiota.serialization.UntypedLong;
import com.microsoft.kiota.serialization.UntypedNode;
import com.microsoft.kiota.serialization.UntypedNull;
import com.microsoft.kiota.serialization.UntypedObject;
import com.microsoft.kiota.serialization.UntypedString;
import com.microsoft.kiota.serialization.ValuedEnum;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonSerializationWriter
implements SerializationWriter {
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private final JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)this.stream, StandardCharsets.UTF_8));
    private Consumer<Parsable> onBeforeObjectSerialization;
    private Consumer<Parsable> onAfterObjectSerialization;
    private BiConsumer<Parsable, SerializationWriter> onStartObjectSerialization;

    @Override
    public void writeStringValue(@Nullable String key, @Nullable String value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value(value);
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writeBooleanValue(@Nullable String key, @Nullable Boolean value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value(value);
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writeShortValue(@Nullable String key, @Nullable Short value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value((Number)value);
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writeByteValue(@Nullable String key, @Nullable Byte value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value((Number)value);
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writeBigDecimalValue(@Nullable String key, @Nullable BigDecimal value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value((Number)value);
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writeIntegerValue(@Nullable String key, @Nullable Integer value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value((Number)value);
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writeFloatValue(@Nullable String key, @Nullable Float value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value((Number)value);
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writeDoubleValue(@Nullable String key, @Nullable Double value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value((Number)value);
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writeLongValue(@Nullable String key, @Nullable Long value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value((Number)value);
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writeUUIDValue(@Nullable String key, @Nullable UUID value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value(value.toString());
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writeOffsetDateTimeValue(@Nullable String key, @Nullable OffsetDateTime value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value(value.format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writeLocalDateValue(@Nullable String key, @Nullable LocalDate value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value(value.format(DateTimeFormatter.ISO_LOCAL_DATE));
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writeLocalTimeValue(@Nullable String key, @Nullable LocalTime value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value(value.format(DateTimeFormatter.ISO_LOCAL_TIME));
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public void writePeriodAndDurationValue(@Nullable String key, @Nullable PeriodAndDuration value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.value(value.toString());
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public <T> void writeCollectionOfPrimitiveValues(@Nullable String key, @Nullable Iterable<T> values) {
        try {
            if (values != null) {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.beginArray();
                for (T t : values) {
                    this.writeAnyValue(null, t);
                }
                this.writer.endArray();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("could not serialize value", ex);
        }
    }

    @Override
    public <T extends Parsable> void writeCollectionOfObjectValues(@Nullable String key, @Nullable Iterable<T> values) {
        try {
            if (values != null) {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.beginArray();
                for (Parsable t : values) {
                    this.writeObjectValue(null, t, new Parsable[0]);
                }
                this.writer.endArray();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("could not serialize value", ex);
        }
    }

    @Override
    public <T extends Enum<T>> void writeCollectionOfEnumValues(@Nullable String key, @Nullable Iterable<T> values) {
        try {
            if (values != null) {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.beginArray();
                for (Enum t : values) {
                    this.writeEnumValue(null, t);
                }
                this.writer.endArray();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("could not serialize value", ex);
        }
    }

    @Override
    public <T extends Parsable> void writeObjectValue(@Nullable String key, @Nullable T value, Parsable ... additionalValuesToMerge) {
        Objects.requireNonNull(additionalValuesToMerge);
        try {
            List nonNullAdditionalValuesToMerge = Stream.of(additionalValuesToMerge).filter(Objects::nonNull).collect(Collectors.toList());
            boolean serializingUntypedNode = value instanceof UntypedNode;
            if (serializingUntypedNode && value != null) {
                if (this.onBeforeObjectSerialization != null) {
                    this.onBeforeObjectSerialization.accept(value);
                }
                this.writeUntypedValue(key, (UntypedNode)value);
                if (this.onAfterObjectSerialization != null) {
                    this.onAfterObjectSerialization.accept(value);
                }
            } else if (value != null || !nonNullAdditionalValuesToMerge.isEmpty()) {
                boolean serializingComposedType;
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                if (this.onBeforeObjectSerialization != null && value != null) {
                    this.onBeforeObjectSerialization.accept(value);
                }
                if (!(serializingComposedType = value instanceof ComposedTypeWrapper)) {
                    this.writer.beginObject();
                }
                if (value != null) {
                    if (this.onStartObjectSerialization != null) {
                        this.onStartObjectSerialization.accept(value, this);
                    }
                    value.serialize(this);
                }
                for (Parsable additionalValueToMerge : nonNullAdditionalValuesToMerge) {
                    if (this.onBeforeObjectSerialization != null) {
                        this.onBeforeObjectSerialization.accept(additionalValueToMerge);
                    }
                    if (this.onStartObjectSerialization != null) {
                        this.onStartObjectSerialization.accept(additionalValueToMerge, this);
                    }
                    additionalValueToMerge.serialize(this);
                    if (this.onAfterObjectSerialization == null) continue;
                    this.onAfterObjectSerialization.accept(additionalValueToMerge);
                }
                if (!serializingComposedType) {
                    this.writer.endObject();
                }
                if (this.onAfterObjectSerialization != null && value != null) {
                    this.onAfterObjectSerialization.accept(value);
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("could not serialize value", ex);
        }
    }

    private void writeUntypedValue(String key, UntypedNode value) {
        Class<?> valueClass = value.getClass();
        if (valueClass.equals(UntypedString.class)) {
            this.writeStringValue(key, ((UntypedString)value).getValue());
        } else if (valueClass.equals(UntypedNull.class)) {
            this.writeNullValue(key);
        } else if (valueClass.equals(UntypedDecimal.class)) {
            this.writeBigDecimalValue(key, ((UntypedDecimal)value).getValue());
        } else if (valueClass.equals(UntypedBoolean.class)) {
            this.writeBooleanValue(key, ((UntypedBoolean)value).getValue());
        } else if (valueClass.equals(UntypedFloat.class)) {
            this.writeFloatValue(key, ((UntypedFloat)value).getValue());
        } else if (valueClass.equals(UntypedDouble.class)) {
            this.writeDoubleValue(key, ((UntypedDouble)value).getValue());
        } else if (valueClass.equals(UntypedLong.class)) {
            this.writeLongValue(key, ((UntypedLong)value).getValue());
        } else if (valueClass.equals(UntypedInteger.class)) {
            this.writeIntegerValue(key, ((UntypedInteger)value).getValue());
        } else if (valueClass.equals(UntypedObject.class)) {
            this.writeUntypedObject(key, (UntypedObject)value);
        } else if (valueClass.equals(UntypedArray.class)) {
            this.writeUntypedArray(key, (UntypedArray)value);
        } else {
            throw new RuntimeException("unknown type to serialize " + valueClass.getName());
        }
    }

    private void writeUntypedObject(String key, UntypedObject value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.beginObject();
                for (Map.Entry fieldEntry : value.getValue().entrySet()) {
                    String fieldKey = (String)fieldEntry.getKey();
                    UntypedNode fieldValue = (UntypedNode)fieldEntry.getValue();
                    this.writeUntypedValue(fieldKey, fieldValue);
                }
                this.writer.endObject();
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    private void writeUntypedArray(String key, UntypedArray value) {
        if (value != null) {
            try {
                if (key != null && !key.isEmpty()) {
                    this.writer.name(key);
                }
                this.writer.beginArray();
                Iterator iterator = value.getValue().iterator();
                while (iterator.hasNext()) {
                    UntypedNode entry = (UntypedNode)iterator.next();
                    this.writeUntypedValue(null, entry);
                }
                this.writer.endArray();
            }
            catch (IOException ex) {
                throw new RuntimeException("could not serialize value", ex);
            }
        }
    }

    @Override
    public <T extends Enum<T>> void writeEnumSetValue(@Nullable String key, @Nullable EnumSet<T> values) {
        Optional<String> concatenatedValue;
        if (values != null && !values.isEmpty() && (concatenatedValue = values.stream().map(v -> this.getStringValueFromValuedEnum(v)).reduce((x, y) -> x + "," + y)).isPresent()) {
            this.writeStringValue(key, concatenatedValue.get());
        }
    }

    @Override
    public <T extends Enum<T>> void writeEnumValue(@Nullable String key, @Nullable T value) {
        if (value != null) {
            this.writeStringValue(key, this.getStringValueFromValuedEnum(value));
        }
    }

    @Override
    public void writeNullValue(@Nullable String key) {
        try {
            if (key != null && !key.isEmpty()) {
                this.writer.name(key);
            }
            this.writer.nullValue();
        }
        catch (IOException ex) {
            throw new RuntimeException("could not serialize value", ex);
        }
    }

    private <T extends Enum<T>> String getStringValueFromValuedEnum(T value) {
        if (value instanceof ValuedEnum) {
            ValuedEnum valued = (ValuedEnum)((Object)value);
            return valued.getValue();
        }
        return null;
    }

    @Override
    @Nonnull
    public InputStream getSerializedContent() {
        try {
            this.writer.flush();
            return new ByteArrayInputStream(this.stream.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.stream.close();
    }

    @Override
    public void writeAdditionalData(@Nonnull Map<String, Object> value) {
        if (value == null) {
            return;
        }
        for (Map.Entry<String, Object> dataValue : value.entrySet()) {
            this.writeAnyValue(dataValue.getKey(), dataValue.getValue());
        }
    }

    private void writeNonParsableObject(@Nullable String key, @Nullable Object value) {
        try {
            if (key != null && !key.isEmpty()) {
                this.writer.name(key);
            }
            if (value == null) {
                this.writer.nullValue();
            } else {
                Class<?> valueClass = value.getClass();
                for (Field oProp : valueClass.getFields()) {
                    this.writeAnyValue(oProp.getName(), oProp.get(value));
                }
            }
        }
        catch (IOException | IllegalAccessException ex) {
            throw new RuntimeException("could not serialize value", ex);
        }
    }

    private void writeAnyValue(@Nullable String key, @Nullable Object value) {
        if (value == null) {
            this.writeNullValue(key);
        } else {
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(String.class)) {
                this.writeStringValue(key, (String)value);
            } else if (valueClass.equals(Boolean.class)) {
                this.writeBooleanValue(key, (Boolean)value);
            } else if (valueClass.equals(Byte.class)) {
                this.writeByteValue(key, (Byte)value);
            } else if (valueClass.equals(Short.class)) {
                this.writeShortValue(key, (Short)value);
            } else if (valueClass.equals(BigDecimal.class)) {
                this.writeBigDecimalValue(key, (BigDecimal)value);
            } else if (valueClass.equals(Float.class)) {
                this.writeFloatValue(key, (Float)value);
            } else if (valueClass.equals(Double.class)) {
                this.writeDoubleValue(key, (Double)value);
            } else if (valueClass.equals(Long.class)) {
                this.writeLongValue(key, (Long)value);
            } else if (valueClass.equals(Integer.class)) {
                this.writeIntegerValue(key, (Integer)value);
            } else if (valueClass.equals(UUID.class)) {
                this.writeUUIDValue(key, (UUID)value);
            } else if (valueClass.equals(OffsetDateTime.class)) {
                this.writeOffsetDateTimeValue(key, (OffsetDateTime)value);
            } else if (valueClass.equals(LocalDate.class)) {
                this.writeLocalDateValue(key, (LocalDate)value);
            } else if (valueClass.equals(LocalTime.class)) {
                this.writeLocalTimeValue(key, (LocalTime)value);
            } else if (value instanceof UntypedNode) {
                this.writeUntypedValue(key, (UntypedNode)value);
            } else if (valueClass.equals(PeriodAndDuration.class)) {
                this.writePeriodAndDurationValue(key, (PeriodAndDuration)value);
            } else if (value instanceof Iterable) {
                this.writeCollectionOfPrimitiveValues(key, (Iterable)value);
            } else if (value instanceof Parsable) {
                this.writeObjectValue(key, (Parsable)value, new Parsable[0]);
            } else if (!valueClass.isPrimitive()) {
                this.writeNonParsableObject(key, value);
            } else {
                throw new RuntimeException("unknown type to serialize " + valueClass.getName());
            }
        }
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnBeforeObjectSerialization() {
        return this.onBeforeObjectSerialization;
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnAfterObjectSerialization() {
        return this.onAfterObjectSerialization;
    }

    @Override
    @Nullable
    public BiConsumer<Parsable, SerializationWriter> getOnStartObjectSerialization() {
        return this.onStartObjectSerialization;
    }

    @Override
    public void setOnBeforeObjectSerialization(@Nullable Consumer<Parsable> value) {
        this.onBeforeObjectSerialization = value;
    }

    @Override
    public void setOnAfterObjectSerialization(@Nullable Consumer<Parsable> value) {
        this.onAfterObjectSerialization = value;
    }

    @Override
    public void setOnStartObjectSerialization(@Nullable BiConsumer<Parsable, SerializationWriter> value) {
        this.onStartObjectSerialization = value;
    }

    @Override
    public void writeByteArrayValue(@Nullable String key, @Nullable byte[] value) {
        if (value != null) {
            this.writeStringValue(key, Base64.getEncoder().encodeToString(value));
        }
    }
}

