/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.KoMorphData;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOSupplier;

class TokenInfoMorphData
implements KoMorphData {
    private final ByteBuffer buffer;
    private final POS.Tag[] posDict;
    public static final int HAS_SINGLE_POS = 1;
    public static final int HAS_READING = 2;

    TokenInfoMorphData(ByteBuffer buffer, IOSupplier<InputStream> posResource) throws IOException {
        this.buffer = buffer;
        try (BufferedInputStream posIS = new BufferedInputStream((InputStream)posResource.get());){
            InputStreamDataInput in = new InputStreamDataInput((InputStream)posIS);
            CodecUtil.checkHeader((DataInput)in, (String)"ko_dict_pos", (int)1, (int)1);
            int posSize = in.readVInt();
            this.posDict = new POS.Tag[posSize];
            for (int j = 0; j < posSize; ++j) {
                this.posDict[j] = POS.resolveTag(in.readByte());
            }
        }
    }

    public int getLeftId(int morphId) {
        return this.buffer.getShort(morphId) >>> 2;
    }

    public int getRightId(int morphId) {
        return this.buffer.getShort(morphId + 2) >>> 2;
    }

    public int getWordCost(int morphId) {
        return this.buffer.getShort(morphId + 4);
    }

    @Override
    public POS.Type getPOSType(int morphId) {
        byte value = (byte)(this.buffer.getShort(morphId) & 3);
        return POS.resolveType(value);
    }

    @Override
    public POS.Tag getLeftPOS(int morphId) {
        return this.posDict[this.getLeftId(morphId)];
    }

    @Override
    public POS.Tag getRightPOS(int morphId) {
        POS.Type type = this.getPOSType(morphId);
        if (type == POS.Type.MORPHEME || type == POS.Type.COMPOUND || this.hasSinglePOS(morphId)) {
            return this.getLeftPOS(morphId);
        }
        byte value = this.buffer.get(morphId + 6);
        return POS.resolveTag(value);
    }

    @Override
    public String getReading(int morphId) {
        if (this.hasReadingData(morphId)) {
            int offset = morphId + 6;
            return this.readString(offset);
        }
        return null;
    }

    @Override
    public KoMorphData.Morpheme[] getMorphemes(int morphId, char[] surfaceForm, int off, int len) {
        POS.Type posType = this.getPOSType(morphId);
        if (posType == POS.Type.MORPHEME) {
            return null;
        }
        int offset = morphId + 6;
        boolean hasSinglePos = this.hasSinglePOS(morphId);
        if (!hasSinglePos) {
            // empty if block
        }
        int n = ++offset;
        ++offset;
        int length = this.buffer.get(n);
        if (length == 0) {
            return null;
        }
        KoMorphData.Morpheme[] morphemes = new KoMorphData.Morpheme[length];
        int surfaceOffset = 0;
        POS.Tag leftPOS = this.getLeftPOS(morphId);
        for (int i = 0; i < length; ++i) {
            String form;
            POS.Tag tag;
            POS.Tag tag2 = tag = hasSinglePos ? leftPOS : POS.resolveTag(this.buffer.get(offset++));
            if (posType == POS.Type.INFLECT) {
                form = this.readString(offset);
                offset += form.length() * 2 + 1;
            } else {
                byte formLen = this.buffer.get(offset++);
                form = new String(surfaceForm, off + surfaceOffset, (int)formLen);
                surfaceOffset += formLen;
            }
            morphemes[i] = new KoMorphData.Morpheme(tag, form);
        }
        return morphemes;
    }

    private String readString(int offset) {
        int strOffset = offset;
        int len = this.buffer.get(strOffset++);
        char[] text = new char[len];
        for (int i = 0; i < len; ++i) {
            text[i] = this.buffer.getChar(strOffset + (i << 1));
        }
        return new String(text);
    }

    private boolean hasSinglePOS(int wordId) {
        return (this.buffer.getShort(wordId + 2) & 1) != 0;
    }

    private boolean hasReadingData(int wordId) {
        return (this.buffer.getShort(wordId + 2) & 2) != 0;
    }
}

