/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.aggregation;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.aggregation.AggregationProfileBreakdown;
import org.elasticsearch.search.profile.aggregation.AggregationProfiler;
import org.elasticsearch.search.profile.aggregation.AggregationTimingType;
import org.elasticsearch.search.profile.aggregation.ProfilingLeafBucketCollector;
import org.elasticsearch.search.sort.SortOrder;

public class ProfilingAggregator
extends Aggregator {
    private final Aggregator delegate;
    private final AggregationProfiler profiler;
    private AggregationProfileBreakdown profileBreakdown;

    public ProfilingAggregator(Aggregator delegate, AggregationProfiler profiler) {
        this.profiler = profiler;
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public ScoreMode scoreMode() {
        return this.delegate.scoreMode();
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public Aggregator parent() {
        return this.delegate.parent();
    }

    @Override
    public Aggregator subAggregator(String name) {
        return this.delegate.subAggregator(name);
    }

    @Override
    public Aggregator resolveSortPath(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        return this.delegate.resolveSortPath(next, path);
    }

    @Override
    public Aggregator.BucketComparator bucketComparator(String key, SortOrder order) {
        return this.delegate.bucketComparator(key, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        InternalAggregation[] result;
        Timer timer = this.profileBreakdown.getNewTimer(AggregationTimingType.BUILD_AGGREGATION);
        timer.start();
        try {
            result = this.delegate.buildAggregations(owningBucketOrds);
        }
        finally {
            timer.stop();
        }
        this.profileBreakdown.addDebugInfo("built_buckets", result.length);
        this.delegate.collectDebugInfo(this.profileBreakdown::addDebugInfo);
        return result;
    }

    @Override
    public void releaseAggregations() {
        this.delegate.releaseAggregations();
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.delegate.buildEmptyAggregation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx) throws IOException {
        Timer timer = this.profileBreakdown.getNewTimer(AggregationTimingType.BUILD_LEAF_COLLECTOR);
        timer.start();
        try {
            ProfilingLeafBucketCollector profilingLeafBucketCollector = new ProfilingLeafBucketCollector(this.delegate.getLeafCollector(aggCtx), this.profileBreakdown);
            return profilingLeafBucketCollector;
        }
        finally {
            timer.stop();
        }
    }

    @Override
    public void preCollection() throws IOException {
        this.profileBreakdown = this.profiler.getQueryBreakdown(this.delegate);
        Timer timer = this.profileBreakdown.getNewTimer(AggregationTimingType.INITIALIZE);
        timer.start();
        try {
            this.delegate.preCollection();
        }
        finally {
            timer.stop();
        }
        this.profiler.pollLastElement();
    }

    @Override
    public void postCollection() throws IOException {
        Timer timer = this.profileBreakdown.getNewTimer(AggregationTimingType.POST_COLLECTION);
        timer.start();
        try {
            this.delegate.postCollection();
        }
        finally {
            timer.stop();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Aggregator[] subAggregators() {
        return this.delegate.subAggregators();
    }

    public static Aggregator unwrap(Aggregator agg) {
        if (agg instanceof ProfilingAggregator) {
            return ((ProfilingAggregator)agg).delegate;
        }
        return agg;
    }
}

