/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.configuration.ClearVotingConfigExclusionsRequest;
import org.elasticsearch.action.admin.cluster.configuration.TransportClearVotingConfigExclusionsAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.EmptyResponseListener;

public class RestClearVotingConfigExclusionsAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "/_cluster/voting_config_exclusions"));
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    @Override
    public String getName() {
        return "clear_voting_config_exclusions_action";
    }

    @Override
    public Set<String> supportedCapabilities() {
        return Set.of("plain_text_empty_response");
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ClearVotingConfigExclusionsRequest req = RestClearVotingConfigExclusionsAction.resolveVotingConfigExclusionsRequest(request);
        return channel -> client.execute(TransportClearVotingConfigExclusionsAction.TYPE, req, new EmptyResponseListener((RestChannel)channel));
    }

    static ClearVotingConfigExclusionsRequest resolveVotingConfigExclusionsRequest(RestRequest request) {
        ClearVotingConfigExclusionsRequest resolvedRequest = new ClearVotingConfigExclusionsRequest(RestUtils.getMasterNodeTimeout(request));
        resolvedRequest.setTimeout(resolvedRequest.masterNodeTimeout());
        resolvedRequest.setWaitForRemoval(request.paramAsBoolean("wait_for_removal", resolvedRequest.getWaitForRemoval()));
        return resolvedRequest;
    }
}

