/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.persistent.ClusterPersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;

public interface PersistentTasks {
    public static final String API_CONTEXT = Metadata.XContentContext.API.toString();
    public static final PersistentTasksCustomMetadata.Assignment LOST_NODE_ASSIGNMENT = new PersistentTasksCustomMetadata.Assignment(null, "awaiting reassignment after node loss");
    public static final PersistentTasksCustomMetadata.Assignment INITIAL_ASSIGNMENT = new PersistentTasksCustomMetadata.Assignment(null, "waiting for initial assignment");

    public long getLastAllocationId();

    public Map<String, PersistentTasksCustomMetadata.PersistentTask<?>> taskMap();

    default public Collection<PersistentTasksCustomMetadata.PersistentTask<?>> tasks() {
        return this.taskMap().values();
    }

    default public PersistentTasksCustomMetadata.PersistentTask<?> getTask(String id) {
        return this.taskMap().get(id);
    }

    default public Collection<PersistentTasksCustomMetadata.PersistentTask<?>> findTasks(String taskName, Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> predicate) {
        return this.tasks().stream().filter(p -> taskName.equals(p.getTaskName())).filter(predicate).toList();
    }

    default public long getNumberOfTasksOnNode(String nodeId, String taskName) {
        return this.tasks().stream().filter(task -> taskName.equals(task.getTaskName()) && nodeId.equals(task.getAssignment().getExecutorNode())).count();
    }

    default public void doWriteTo(StreamOutput out) throws IOException {
        out.writeLong(this.getLastAllocationId());
        Map filteredTasks = this.tasks().stream().filter(t -> t.getParams().supportsVersion(out.getTransportVersion())).collect(Collectors.toMap(PersistentTasksCustomMetadata.PersistentTask::getId, Function.identity()));
        out.writeMap(filteredTasks, StreamOutput::writeWriteable);
    }

    default public Iterator<? extends ToXContent> doToXContentChunked() {
        return Iterators.concat(Iterators.single((builder, params) -> builder.field("last_allocation_id", this.getLastAllocationId())), ChunkedToXContentHelper.array("tasks", this.tasks().iterator()));
    }

    public Builder<?> toBuilder();

    @Nullable
    public static PersistentTasks getTasks(ClusterState clusterState, @Nullable ProjectId projectId) {
        if (projectId != null) {
            return PersistentTasksCustomMetadata.get(clusterState.metadata().getProject(projectId));
        }
        return ClusterPersistentTasksCustomMetadata.get(clusterState.metadata());
    }

    public static Stream<Tuple<ProjectId, PersistentTasks>> getAllTasks(ClusterState currentState) {
        Stream<Tuple<ProjectId, PersistentTasks>> streamOfProjectTasks = currentState.metadata().projects().keySet().stream().filter(projectId -> PersistentTasks.getTasks(currentState, projectId) != null).map(projectId -> new Tuple<ProjectId, PersistentTasks>((ProjectId)projectId, PersistentTasks.getTasks(currentState, projectId)));
        PersistentTasks clusterTasks = PersistentTasks.getTasks(currentState, null);
        if (clusterTasks == null) {
            return streamOfProjectTasks;
        }
        return Stream.concat(Stream.of(new Tuple<Object, PersistentTasks>(null, clusterTasks)), streamOfProjectTasks);
    }

    public static String taskTypeString(@Nullable ProjectId projectId) {
        return PersistentTasks.taskTypeString(projectId == null ? null : projectId.id());
    }

    public static String taskTypeString(@Nullable String projectId) {
        return projectId == null ? "cluster" : "project [" + projectId + "]";
    }

    public static long getMaxLastAllocationId(ClusterState clusterState) {
        return PersistentTasks.getAllTasks(clusterState).map(tuple -> ((PersistentTasks)tuple.v2()).getLastAllocationId()).max(Long::compare).orElse(0L);
    }

    public static abstract class Builder<T extends Builder<T>> {
        private final Map<String, PersistentTasksCustomMetadata.PersistentTask<?>> tasks = new HashMap();
        private long lastAllocationId;
        private boolean changed;

        protected Builder() {
        }

        protected Builder(PersistentTasks tasksInProgress) {
            if (tasksInProgress != null) {
                this.tasks.putAll(tasksInProgress.taskMap());
                this.lastAllocationId = tasksInProgress.getLastAllocationId();
            } else {
                this.lastAllocationId = 0L;
            }
        }

        public long getLastAllocationId() {
            return this.lastAllocationId;
        }

        protected T setLastAllocationId(long currentId) {
            this.lastAllocationId = currentId;
            return (T)this;
        }

        protected T setLastAllocationId(ClusterState clusterState) {
            return this.setLastAllocationId(PersistentTasks.getMaxLastAllocationId(clusterState));
        }

        protected <Params extends PersistentTaskParams> T setTasks(List<TaskBuilder<Params>> tasks) {
            for (TaskBuilder<Params> builder : tasks) {
                PersistentTasksCustomMetadata.PersistentTask<Params> task = builder.build();
                this.tasks.put(task.getId(), task);
            }
            return (T)this;
        }

        private long getNextAllocationId() {
            ++this.lastAllocationId;
            return this.lastAllocationId;
        }

        public <Params extends PersistentTaskParams> T addTask(String taskId, String taskName, Params params, PersistentTasksCustomMetadata.Assignment assignment) {
            this.changed = true;
            PersistentTasksCustomMetadata.PersistentTask<Params> previousTask = this.tasks.put(taskId, new PersistentTasksCustomMetadata.PersistentTask<Params>(taskId, taskName, params, this.getNextAllocationId(), assignment));
            if (previousTask != null) {
                throw new ResourceAlreadyExistsException("Trying to override task with id {" + taskId + "}", new Object[0]);
            }
            return (T)this;
        }

        public T reassignTask(String taskId, PersistentTasksCustomMetadata.Assignment assignment) {
            PersistentTasksCustomMetadata.PersistentTask<?> taskInProgress = this.tasks.get(taskId);
            if (taskInProgress == null) {
                throw new ResourceNotFoundException("cannot reassign task with id {" + taskId + "}, the task no longer exists", new Object[0]);
            }
            this.changed = true;
            this.tasks.put(taskId, new PersistentTasksCustomMetadata.PersistentTask(taskInProgress, this.getNextAllocationId(), assignment));
            return (T)this;
        }

        public T updateTaskState(String taskId, PersistentTaskState taskState) {
            PersistentTasksCustomMetadata.PersistentTask<?> taskInProgress = this.tasks.get(taskId);
            if (taskInProgress == null) {
                throw new ResourceNotFoundException("cannot update task with id {" + taskId + "}, the task no longer exists", new Object[0]);
            }
            this.changed = true;
            this.tasks.put(taskId, new PersistentTasksCustomMetadata.PersistentTask(taskInProgress, taskState));
            return (T)this;
        }

        public T removeTask(String taskId) {
            if (this.tasks.remove(taskId) == null) {
                throw new ResourceNotFoundException("cannot remove task with id {" + taskId + "}, the task no longer exists", new Object[0]);
            }
            this.changed = true;
            return (T)this;
        }

        public boolean hasTask(String taskId) {
            return this.tasks.containsKey(taskId);
        }

        public boolean hasTask(String taskId, long allocationId) {
            PersistentTasksCustomMetadata.PersistentTask<?> taskInProgress = this.tasks.get(taskId);
            if (taskInProgress != null) {
                return taskInProgress.getAllocationId() == allocationId;
            }
            return false;
        }

        Map<String, PersistentTasksCustomMetadata.PersistentTask<?>> getCurrentTasks() {
            return this.tasks;
        }

        Set<String> getCurrentTaskIds() {
            return this.tasks.keySet();
        }

        public boolean isChanged() {
            return this.changed;
        }

        public abstract PersistentTasks build();

        public final ClusterState buildAndUpdate(ClusterState currentState, ProjectId projectId) {
            if (this.isChanged()) {
                ClusterState updatedClusterState = this.doBuildAndUpdate(currentState, projectId);
                assert (PersistentTasksClusterService.assertAllocationIdsConsistency(updatedClusterState));
                assert (PersistentTasksClusterService.assertUniqueTaskIdForClusterScopeTasks(updatedClusterState));
                return updatedClusterState;
            }
            return currentState;
        }

        protected abstract ClusterState doBuildAndUpdate(ClusterState var1, ProjectId var2);
    }

    public static class TaskBuilder<Params extends PersistentTaskParams> {
        private String id;
        private long allocationId;
        private String taskName;
        private Params params;
        private PersistentTaskState state;
        private PersistentTasksCustomMetadata.Assignment assignment = INITIAL_ASSIGNMENT;
        private Long allocationIdOnLastStatusUpdate;

        public TaskBuilder<Params> setId(String id) {
            this.id = id;
            return this;
        }

        public TaskBuilder<Params> setAllocationId(long allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public TaskBuilder<Params> setTaskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public TaskBuilder<Params> setParams(Params params) {
            this.params = params;
            return this;
        }

        public TaskBuilder<Params> setState(PersistentTaskState state) {
            this.state = state;
            return this;
        }

        public TaskBuilder<Params> setAssignment(PersistentTasksCustomMetadata.Assignment assignment) {
            this.assignment = assignment;
            return this;
        }

        public TaskBuilder<Params> setAllocationIdOnLastStatusUpdate(Long allocationIdOnLastStatusUpdate) {
            this.allocationIdOnLastStatusUpdate = allocationIdOnLastStatusUpdate;
            return this;
        }

        public PersistentTasksCustomMetadata.PersistentTask<Params> build() {
            return new PersistentTasksCustomMetadata.PersistentTask<Params>(this.id, this.allocationId, this.taskName, this.params, this.state, this.assignment, this.allocationIdOnLastStatusUpdate);
        }
    }

    public static class TaskDescriptionBuilder<Params extends PersistentTaskParams> {
        private final String taskName;
        private Params params;
        private PersistentTaskState state;

        private TaskDescriptionBuilder(String taskName) {
            this.taskName = taskName;
        }

        private TaskDescriptionBuilder<Params> setParams(Params params) {
            this.params = params;
            return this;
        }

        private TaskDescriptionBuilder<Params> setState(PersistentTaskState state) {
            this.state = state;
            return this;
        }
    }

    public static class Parsers {
        public static final ConstructingObjectParser<PersistentTasksCustomMetadata.Assignment, Void> ASSIGNMENT_PARSER = new ConstructingObjectParser("assignment", objects -> new PersistentTasksCustomMetadata.Assignment((String)objects[0], (String)objects[1]));
        static final ObjectParser<TaskBuilder<PersistentTaskParams>, Void> PERSISTENT_TASK_PARSER = new ObjectParser("tasks", TaskBuilder::new);
        private static final ObjectParser.NamedObjectParser<TaskDescriptionBuilder<PersistentTaskParams>, Void> TASK_DESCRIPTION_PARSER;

        static {
            ObjectParser<TaskDescriptionBuilder, String> parser = new ObjectParser<TaskDescriptionBuilder, String>("named");
            parser.declareObject(TaskDescriptionBuilder::setParams, (p, c) -> p.namedObject(PersistentTaskParams.class, (String)c, null), new ParseField("params", new String[0]));
            parser.declareObject(TaskDescriptionBuilder::setState, (p, c) -> p.namedObject(PersistentTaskState.class, (String)c, null), new ParseField("state", "status"));
            TASK_DESCRIPTION_PARSER = (p, c, name) -> parser.parse(p, new TaskDescriptionBuilder(name), name);
            ASSIGNMENT_PARSER.declareStringOrNull(ConstructingObjectParser.constructorArg(), new ParseField("executor_node", new String[0]));
            ASSIGNMENT_PARSER.declareStringOrNull(ConstructingObjectParser.constructorArg(), new ParseField("explanation", new String[0]));
            PERSISTENT_TASK_PARSER.declareString(TaskBuilder::setId, new ParseField("id", new String[0]));
            PERSISTENT_TASK_PARSER.declareString(TaskBuilder::setTaskName, new ParseField("name", new String[0]));
            PERSISTENT_TASK_PARSER.declareLong(TaskBuilder::setAllocationId, new ParseField("allocation_id", new String[0]));
            PERSISTENT_TASK_PARSER.declareNamedObjects((taskBuilder, objects) -> {
                if (objects.size() != 1) {
                    throw new IllegalArgumentException("only one task description per task is allowed");
                }
                TaskDescriptionBuilder builder = (TaskDescriptionBuilder)objects.get(0);
                taskBuilder.setTaskName(builder.taskName);
                taskBuilder.setParams(builder.params);
                taskBuilder.setState(builder.state);
            }, TASK_DESCRIPTION_PARSER, new ParseField("task", new String[0]));
            PERSISTENT_TASK_PARSER.declareObject(TaskBuilder::setAssignment, ASSIGNMENT_PARSER, new ParseField("assignment", new String[0]));
            PERSISTENT_TASK_PARSER.declareLong(TaskBuilder::setAllocationIdOnLastStatusUpdate, new ParseField("allocation_id_on_last_status_update", new String[0]));
        }
    }
}

