/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.explain;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExplainResponse
extends ActionResponse
implements ToXContentObject {
    static final ParseField _INDEX = new ParseField("_index", new String[0]);
    static final ParseField _ID = new ParseField("_id", new String[0]);
    private static final ParseField MATCHED = new ParseField("matched", new String[0]);
    static final ParseField EXPLANATION = new ParseField("explanation", new String[0]);
    static final ParseField VALUE = new ParseField("value", new String[0]);
    static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    static final ParseField DETAILS = new ParseField("details", new String[0]);
    static final ParseField GET = new ParseField("get", new String[0]);
    private final String index;
    private final String id;
    private final boolean exists;
    private Explanation explanation;
    private GetResult getResult;

    public ExplainResponse(String index, String id, boolean exists) {
        this.index = index;
        this.id = id;
        this.exists = exists;
    }

    public ExplainResponse(String index, String id, boolean exists, Explanation explanation) {
        this(index, id, exists);
        this.explanation = explanation;
    }

    public ExplainResponse(String index, String id, boolean exists, Explanation explanation, GetResult getResult) {
        this(index, id, exists, explanation);
        this.getResult = getResult;
    }

    public ExplainResponse(StreamInput in) throws IOException {
        this.index = in.readString();
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            in.readString();
        }
        this.id = in.readString();
        this.exists = in.readBoolean();
        if (in.readBoolean()) {
            this.explanation = Lucene.readExplanation(in);
        }
        if (in.readBoolean()) {
            this.getResult = new GetResult(in);
        }
    }

    public String getIndex() {
        return this.index;
    }

    public String getId() {
        return this.id;
    }

    public Explanation getExplanation() {
        return this.explanation;
    }

    public boolean isMatch() {
        return this.explanation != null && this.explanation.isMatch();
    }

    public boolean hasExplanation() {
        return this.explanation != null;
    }

    public boolean isExists() {
        return this.exists;
    }

    public GetResult getGetResult() {
        return this.getResult;
    }

    public RestStatus status() {
        return this.exists ? RestStatus.OK : RestStatus.NOT_FOUND;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeString("_doc");
        }
        out.writeString(this.id);
        out.writeBoolean(this.exists);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (this.getResult == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.getResult.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(_INDEX.getPreferredName(), this.index);
        builder.field(_ID.getPreferredName(), this.id);
        builder.field(MATCHED.getPreferredName(), this.isMatch());
        if (this.hasExplanation()) {
            builder.startObject(EXPLANATION.getPreferredName());
            ExplainResponse.buildExplanation(builder, this.explanation);
            builder.endObject();
        }
        if (this.getResult != null) {
            builder.startObject(GET.getPreferredName());
            this.getResult.toXContentEmbedded(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private static void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
        builder.field(VALUE.getPreferredName(), explanation.getValue());
        builder.field(DESCRIPTION.getPreferredName(), explanation.getDescription());
        Explanation[] innerExps = explanation.getDetails();
        if (innerExps != null) {
            builder.startArray(DETAILS.getPreferredName());
            for (Explanation exp : innerExps) {
                builder.startObject();
                ExplainResponse.buildExplanation(builder, exp);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExplainResponse other = (ExplainResponse)obj;
        return this.index.equals(other.index) && this.id.equals(other.id) && Objects.equals(this.explanation, other.explanation) && this.getResult.isExists() == other.getResult.isExists() && Objects.equals(this.getResult.sourceAsMap(), other.getResult.sourceAsMap()) && Objects.equals(this.getResult.getFields(), other.getResult.getFields());
    }

    public int hashCode() {
        return Objects.hash(this.index, this.id, this.explanation, this.getResult.isExists(), this.getResult.sourceAsMap(), this.getResult.getFields());
    }
}

