/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.core.search.Rescore;
import co.elastic.clients.elasticsearch.core.search.RescoreVariant;
import co.elastic.clients.elasticsearch.core.search.ScoreMode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RescoreQuery
implements RescoreVariant,
JsonpSerializable {
    private final Query query;
    @Nullable
    private final Double queryWeight;
    @Nullable
    private final Double rescoreQueryWeight;
    @Nullable
    private final ScoreMode scoreMode;
    public static final JsonpDeserializer<RescoreQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RescoreQuery::setupRescoreQueryDeserializer);

    private RescoreQuery(Builder builder) {
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.queryWeight = builder.queryWeight;
        this.rescoreQueryWeight = builder.rescoreQueryWeight;
        this.scoreMode = builder.scoreMode;
    }

    public static RescoreQuery of(Function<Builder, ObjectBuilder<RescoreQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Rescore.Kind _rescoreKind() {
        return Rescore.Kind.Query;
    }

    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Double queryWeight() {
        return this.queryWeight;
    }

    @Nullable
    public final Double rescoreQueryWeight() {
        return this.rescoreQueryWeight;
    }

    @Nullable
    public final ScoreMode scoreMode() {
        return this.scoreMode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("rescore_query");
        this.query.serialize(generator, mapper);
        if (this.queryWeight != null) {
            generator.writeKey("query_weight");
            generator.write(this.queryWeight);
        }
        if (this.rescoreQueryWeight != null) {
            generator.writeKey("rescore_query_weight");
            generator.write(this.rescoreQueryWeight);
        }
        if (this.scoreMode != null) {
            generator.writeKey("score_mode");
            this.scoreMode.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRescoreQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::query, Query._DESERIALIZER, "rescore_query");
        op.add(Builder::queryWeight, JsonpDeserializer.doubleDeserializer(), "query_weight");
        op.add(Builder::rescoreQueryWeight, JsonpDeserializer.doubleDeserializer(), "rescore_query_weight");
        op.add(Builder::scoreMode, ScoreMode._DESERIALIZER, "score_mode");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RescoreQuery> {
        private Query query;
        @Nullable
        private Double queryWeight;
        @Nullable
        private Double rescoreQueryWeight;
        @Nullable
        private ScoreMode scoreMode;

        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder query(QueryVariant value) {
            this.query = value._toQuery();
            return this;
        }

        public final Builder queryWeight(@Nullable Double value) {
            this.queryWeight = value;
            return this;
        }

        public final Builder rescoreQueryWeight(@Nullable Double value) {
            this.rescoreQueryWeight = value;
            return this;
        }

        public final Builder scoreMode(@Nullable ScoreMode value) {
            this.scoreMode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RescoreQuery build() {
            this._checkSingleUse();
            return new RescoreQuery(this);
        }
    }
}

