/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import org.apache.derby.shared.common.stream.PrintWriterGetHeader;

public class ErrorStringBuilder {
    private StringWriter stringWriter;
    private PrintWriter printWriter;
    private PrintWriterGetHeader headerGetter;

    public ErrorStringBuilder(PrintWriterGetHeader headerGetter) {
        this.headerGetter = headerGetter;
        this.stringWriter = new StringWriter();
        this.printWriter = new PrintWriter(this.stringWriter);
    }

    public void append(String s) {
        if (this.headerGetter != null) {
            this.printWriter.print(this.headerGetter.getHeader());
        }
        this.printWriter.print(s);
    }

    public void appendln(String s) {
        if (this.headerGetter != null) {
            this.printWriter.print(this.headerGetter.getHeader());
        }
        this.printWriter.println(s);
    }

    public void stackTrace(Throwable t) {
        int level = 0;
        while (t != null) {
            SQLException next;
            if (level > 0) {
                this.printWriter.println("============= begin nested exception, level (" + level + ") ===========");
            }
            t.printStackTrace(this.printWriter);
            t = t instanceof SQLException ? ((next = ((SQLException)t).getNextException()) == null ? t.getCause() : next) : t.getCause();
            if (level > 0) {
                this.printWriter.println("============= end nested exception, level (" + level + ") ===========");
            }
            ++level;
        }
    }

    public void reset() {
        this.stringWriter.getBuffer().setLength(0);
    }

    public StringBuffer get() {
        return this.stringWriter.getBuffer();
    }
}

