/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;

public class ExceptionsHelper {
    private static String NO_KNOWN_MODEL_ERROR = "No known trained model with model_id [{}], you may need to create it or load it into the cluster with eland";

    private ExceptionsHelper() {
    }

    public static ResourceNotFoundException missingJobException(String jobId) {
        return new ResourceNotFoundException(Messages.getMessage("No known job with id ''{0}''", jobId), new Object[0]);
    }

    public static ResourceAlreadyExistsException jobAlreadyExists(String jobId) {
        return new ResourceAlreadyExistsException(Messages.getMessage("The job cannot be created with the Id ''{0}''. The Id is already used.", jobId), new Object[0]);
    }

    public static ResourceNotFoundException missingDatafeedException(String datafeedId) {
        return new ResourceNotFoundException(Messages.getMessage("No datafeed with id [{0}] exists", datafeedId), new Object[0]);
    }

    public static ResourceAlreadyExistsException datafeedAlreadyExists(String datafeedId) {
        return new ResourceAlreadyExistsException(Messages.getMessage("A datafeed with id [{0}] already exists", datafeedId), new Object[0]);
    }

    public static ResourceNotFoundException missingDataFrameAnalytics(String id) {
        return new ResourceNotFoundException("No known data frame analytics with id [{}]", id);
    }

    public static ResourceAlreadyExistsException dataFrameAnalyticsAlreadyExists(String id) {
        return new ResourceAlreadyExistsException("A data frame analytics with id [{}] already exists", id);
    }

    public static ResourceNotFoundException missingModelDeployment(String deploymentId) {
        return new ResourceNotFoundException("No known model deployment with id [{}]", deploymentId);
    }

    public static ResourceNotFoundException missingTrainedModel(String modelId) {
        return new ResourceNotFoundException(NO_KNOWN_MODEL_ERROR, modelId);
    }

    public static ResourceNotFoundException missingTrainedModel(String modelId, Exception cause) {
        return new ResourceNotFoundException(NO_KNOWN_MODEL_ERROR, (Throwable)cause, modelId);
    }

    public static ElasticsearchException serverError(String msg) {
        return new ElasticsearchException(msg, new Object[0]);
    }

    public static ElasticsearchException serverError(String msg, Throwable cause) {
        return new ElasticsearchException(msg, cause, new Object[0]);
    }

    public static ElasticsearchException serverError(String msg, Object ... args) {
        return new ElasticsearchException(msg, args);
    }

    public static ElasticsearchException serverError(String msg, Throwable cause, Object ... args) {
        return new ElasticsearchException(msg, cause, args);
    }

    public static ElasticsearchStatusException conflictStatusException(String msg, Throwable cause, Object ... args) {
        return new ElasticsearchStatusException(msg, RestStatus.CONFLICT, cause, args);
    }

    public static ElasticsearchStatusException conflictStatusException(String msg, Object ... args) {
        return new ElasticsearchStatusException(msg, RestStatus.CONFLICT, args);
    }

    public static ElasticsearchStatusException badRequestException(String msg, Throwable cause, Object ... args) {
        return new ElasticsearchStatusException(msg, RestStatus.BAD_REQUEST, cause, args);
    }

    public static ElasticsearchStatusException badRequestException(String msg, Object ... args) {
        return new ElasticsearchStatusException(msg, RestStatus.BAD_REQUEST, args);
    }

    public static ElasticsearchStatusException entityNotFoundException(String msg, Object ... args) {
        return new ElasticsearchStatusException(msg, RestStatus.NOT_FOUND, args);
    }

    public static ElasticsearchStatusException taskOperationFailureToStatusException(TaskOperationFailure failure) {
        return new ElasticsearchStatusException(failure.getCause().getMessage(), failure.getStatus(), failure.getCause(), new Object[0]);
    }

    public static String shardFailuresToErrorMsg(String jobId, ShardSearchFailure[] shardFailures) {
        if (shardFailures == null || shardFailures.length == 0) {
            throw new IllegalStateException("Invalid call with null or empty shardFailures");
        }
        SearchShardTarget shardTarget = shardFailures[0].shard();
        return "[" + jobId + "] Search request returned shard failures; first failure: shard [" + String.valueOf(shardTarget == null ? "_na" : shardTarget) + "], reason [" + shardFailures[0].reason() + "]; see logs for more info";
    }

    public static <T> T requireNonNull(T obj, String paramName) {
        if (obj == null) {
            throw new IllegalArgumentException("[" + paramName + "] must not be null.");
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj, ParseField paramName) {
        return ExceptionsHelper.requireNonNull(obj, paramName.getPreferredName());
    }

    public static Throwable unwrapCause(Throwable t) {
        return org.elasticsearch.ExceptionsHelper.unwrapCause(t);
    }

    public static Throwable findSearchExceptionRootCause(Throwable t) {
        Throwable unwrappedThrowable = ExceptionsHelper.unwrapCause(t);
        if (unwrappedThrowable instanceof SearchPhaseExecutionException) {
            SearchPhaseExecutionException searchPhaseException = (SearchPhaseExecutionException)unwrappedThrowable;
            for (ShardSearchFailure shardFailure : searchPhaseException.shardFailures()) {
                Throwable unwrappedShardFailure = ExceptionsHelper.unwrapCause(shardFailure.getCause());
                if (!(unwrappedShardFailure instanceof ElasticsearchException)) continue;
                return unwrappedShardFailure;
            }
        }
        return unwrappedThrowable;
    }
}

