/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;

public class XContentFormattedException
extends ElasticsearchException
implements ChunkedToXContent {
    public static final String X_CONTENT_PARAM = "detailedErrorsEnabled";
    private final RestStatus status;
    private final Throwable cause;

    public XContentFormattedException(String message, RestStatus status) {
        super(message, new Object[0]);
        this.status = Objects.requireNonNull(status);
        this.cause = null;
    }

    public XContentFormattedException(Throwable cause, RestStatus status) {
        super(cause);
        this.status = Objects.requireNonNull(status);
        this.cause = cause;
    }

    public XContentFormattedException(String message, Throwable cause, RestStatus status) {
        super(message, cause, new Object[0]);
        this.status = Objects.requireNonNull(status);
        this.cause = cause;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.startObject(), Iterators.single((b, p) -> {
            Exception exception;
            Throwable patt0$temp = this.cause;
            if (patt0$temp instanceof Exception) {
                Exception e = (Exception)patt0$temp;
                exception = e;
            } else {
                exception = this;
            }
            return ElasticsearchException.generateFailureXContent(b, p, exception, params.paramAsBoolean(X_CONTENT_PARAM, false));
        }), Iterators.single((b, p) -> b.field("status", this.status.getStatus())), ChunkedToXContentHelper.endObject());
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(RestApiVersion restApiVersion, ToXContent.Params params) {
        return ChunkedToXContent.super.toXContentChunked(restApiVersion, params);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunkedV8(ToXContent.Params params) {
        return ChunkedToXContent.super.toXContentChunkedV8(params);
    }

    @Override
    public boolean isFragment() {
        return super.isFragment();
    }
}

