/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;

public class UpdateInferenceModelAction
extends ActionType<Response> {
    public static final UpdateInferenceModelAction INSTANCE = new UpdateInferenceModelAction();
    public static final String NAME = "cluster:admin/xpack/inference/update";

    public UpdateInferenceModelAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final ModelConfigurations model;

        public Response(ModelConfigurations model) {
            this.model = model;
        }

        public Response(StreamInput in) throws IOException {
            this.model = new ModelConfigurations(in);
        }

        public ModelConfigurations getModel() {
            return this.model;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.model.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.model.toFilteredXContent(builder, params);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.model, response.model);
        }

        public int hashCode() {
            return Objects.hash(this.model);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String inferenceEntityId;
        private final BytesReference content;
        private final XContentType contentType;
        private final TaskType taskType;
        private Settings settings;

        public Request(String inferenceEntityId, BytesReference content, XContentType contentType, TaskType taskType, TimeValue timeout) {
            super(timeout, DEFAULT_ACK_TIMEOUT);
            this.inferenceEntityId = inferenceEntityId;
            this.content = content;
            this.contentType = contentType;
            this.taskType = taskType;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.inferenceEntityId = in.readString();
            this.taskType = TaskType.fromStream(in);
            this.content = in.readBytesReference();
            this.contentType = in.readEnum(XContentType.class);
        }

        public String getInferenceEntityId() {
            return this.inferenceEntityId;
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public BytesReference getContent() {
            return this.content;
        }

        public Settings getContentAsSettings() {
            if (this.settings == null) {
                Object value;
                String key;
                Object object;
                Map tempMap;
                Object object2;
                Map<String, Object> unvalidatedMap = XContentHelper.convertToMap(this.content, false, this.contentType).v2();
                HashMap serviceSettings = new HashMap();
                HashMap taskSettings = new HashMap();
                TaskType taskType = null;
                if (unvalidatedMap.isEmpty()) {
                    throw new ElasticsearchStatusException("Request body is empty", RestStatus.BAD_REQUEST, new Object[0]);
                }
                if (unvalidatedMap.containsKey("task_type")) {
                    object2 = unvalidatedMap.get("task_type");
                    if (!(object2 instanceof String)) {
                        throw new ElasticsearchStatusException("Failed to parse [task_type] in update request [{}]", RestStatus.INTERNAL_SERVER_ERROR, unvalidatedMap.toString());
                    }
                    String taskTypeString = (String)object2;
                    taskType = TaskType.fromStringOrStatusException(taskTypeString);
                    unvalidatedMap.remove("task_type");
                }
                if (unvalidatedMap.containsKey("service_settings")) {
                    object2 = unvalidatedMap.get("service_settings");
                    if (object2 instanceof Map) {
                        tempMap = (Map)object2;
                        for (Map.Entry entry : tempMap.entrySet()) {
                            object = entry.getKey();
                            if (object instanceof String) {
                                key = (String)object;
                                object = entry.getValue();
                                if (object instanceof Object) {
                                    value = object;
                                    serviceSettings.put(key, value);
                                    continue;
                                }
                            }
                            throw new ElasticsearchStatusException("Failed to parse update request [{}]", RestStatus.INTERNAL_SERVER_ERROR, unvalidatedMap.toString());
                        }
                        unvalidatedMap.remove("service_settings");
                    } else {
                        throw new ElasticsearchStatusException("Unable to parse service settings in the request [{}]", RestStatus.BAD_REQUEST, unvalidatedMap.toString());
                    }
                }
                if (unvalidatedMap.containsKey("task_settings")) {
                    object2 = unvalidatedMap.get("task_settings");
                    if (object2 instanceof Map) {
                        tempMap = (Map)object2;
                        for (Map.Entry entry : tempMap.entrySet()) {
                            object = entry.getKey();
                            if (object instanceof String) {
                                key = (String)object;
                                object = entry.getValue();
                                if (object instanceof Object) {
                                    value = object;
                                    taskSettings.put(key, value);
                                    continue;
                                }
                            }
                            throw new ElasticsearchStatusException("Failed to parse update request [{}]", RestStatus.INTERNAL_SERVER_ERROR, unvalidatedMap.toString());
                        }
                        unvalidatedMap.remove("task_settings");
                    } else {
                        throw new ElasticsearchStatusException("Unable to parse task settings in the request [{}]", RestStatus.BAD_REQUEST, unvalidatedMap.toString());
                    }
                }
                if (!unvalidatedMap.isEmpty()) {
                    throw new ElasticsearchStatusException("Request contained fields which cannot be updated, remove these fields and try again [{}]", RestStatus.BAD_REQUEST, unvalidatedMap.toString());
                }
                this.settings = new Settings(!serviceSettings.isEmpty() ? Collections.unmodifiableMap(serviceSettings) : null, !taskSettings.isEmpty() ? Collections.unmodifiableMap(taskSettings) : null, taskType);
            }
            return this.settings;
        }

        public XContentType getContentType() {
            return this.contentType;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.inferenceEntityId);
            this.taskType.writeTo(out);
            out.writeBytesReference(this.content);
            XContentHelper.writeTo(out, this.contentType);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = new ActionRequestValidationException();
            if (!MlStrings.isValidId(this.inferenceEntityId)) {
                validationException.addValidationError(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", "inference_id", this.inferenceEntityId));
            }
            if (!validationException.validationErrors().isEmpty()) {
                return validationException;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.inferenceEntityId, request.inferenceEntityId) && Objects.equals(this.content, request.content) && this.contentType == request.contentType && this.taskType == request.taskType;
        }

        public int hashCode() {
            return Objects.hash(this.inferenceEntityId, this.content, this.contentType, this.taskType);
        }
    }

    public record Settings(@Nullable Map<String, Object> serviceSettings, @Nullable Map<String, Object> taskSettings, @Nullable TaskType taskType) {
    }
}

