/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class SumAggregator
extends NumericMetricsAggregator.SingleDoubleValue {
    protected final DocValueFormat format;
    protected DoubleArray sums;
    protected DoubleArray compensations;

    SumAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, valuesSourceConfig, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.format = valuesSourceConfig.format();
        BigArrays bigArrays = context.bigArrays();
        this.sums = bigArrays.newDoubleArray(1L, true);
        this.compensations = bigArrays.newDoubleArray(1L, true);
    }

    @Override
    protected LeafBucketCollector getLeafCollector(final SortedNumericDoubleValues values, LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    SumAggregator.this.maybeGrow(bucket);
                    SumAggregator.sumSortedDoubles(bucket, values, SumAggregator.this.sums, SumAggregator.this.compensations);
                }
            }
        };
    }

    static int sumSortedDoubles(long bucket, SortedNumericDoubleValues values, DoubleArray sums, DoubleArray compensations) throws IOException {
        int valueCount = values.docValueCount();
        double value = sums.get(bucket);
        double delta = compensations.get(bucket);
        for (int i = 0; i < valueCount; ++i) {
            double added = values.nextValue();
            value = SumAggregator.addIfNonOrInf(added, value);
            if (!Double.isFinite(value)) continue;
            double correctedSum = added + delta;
            double updatedValue = value + correctedSum;
            delta = correctedSum - (updatedValue - value);
            value = updatedValue;
        }
        compensations.set(bucket, delta);
        sums.set(bucket, value);
        return valueCount;
    }

    private static double addIfNonOrInf(double added, double value) {
        if (Double.isFinite(added)) {
            return value;
        }
        return added + value;
    }

    @Override
    protected LeafBucketCollector getLeafCollector(final NumericDoubleValues values, LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    SumAggregator.this.maybeGrow(bucket);
                    SumAggregator.computeSum(bucket, values.doubleValue(), SumAggregator.this.sums, SumAggregator.this.compensations);
                }
            }
        };
    }

    static void computeSum(long bucket, double added, DoubleArray sums, DoubleArray compensations) {
        double value = SumAggregator.addIfNonOrInf(added, sums.get(bucket));
        if (Double.isFinite(value)) {
            double delta = compensations.get(bucket);
            double correctedSum = added + delta;
            double updatedValue = value + correctedSum;
            delta = correctedSum - (updatedValue - value);
            value = updatedValue;
            compensations.set(bucket, delta);
        }
        sums.set(bucket, value);
    }

    protected final void maybeGrow(long bucket) {
        if (bucket >= this.sums.size()) {
            this.doGrow(bucket, this.bigArrays());
        }
    }

    protected void doGrow(long bucket, BigArrays bigArrays) {
        this.sums = bigArrays.grow(this.sums, bucket + 1L);
        this.compensations = bigArrays.grow(this.compensations, bucket + 1L);
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (owningBucketOrd >= this.sums.size()) {
            return 0.0;
        }
        return this.sums.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new Sum(this.name, this.sums.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return Sum.empty(this.name, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.sums, this.compensations);
    }
}

