/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public record PluginContext(@Nonnull String pipelineId, @Nonnull String pluginId) {
    public ScheduledExecutorService newSingleThreadScheduledExecutor(@Nonnull String purpose) {
        return Executors.newSingleThreadScheduledExecutor(this.newNamedThreadFactory(purpose));
    }

    public ThreadFactory newNamedThreadFactory(@Nonnull String purpose) {
        final String threadNamePrefix = "[" + this.pipelineId + "]filter|elastic_integration@" + this.pluginId + "|" + purpose + "-";
        return new ThreadFactory(){
            final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(@Nullable Runnable runnable) {
                Thread thread = new Thread(runnable, threadNamePrefix + this.threadNumber.getAndIncrement());
                if (thread.isDaemon()) {
                    thread.setDaemon(false);
                }
                if (thread.getPriority() != 5) {
                    thread.setPriority(5);
                }
                return thread;
            }
        };
    }
}

