/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.CohereInputType;
import co.elastic.clients.elasticsearch.inference.CohereTruncateType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CohereTaskSettings
implements JsonpSerializable {
    @Nullable
    private final CohereInputType inputType;
    @Nullable
    private final Boolean returnDocuments;
    @Nullable
    private final Integer topN;
    @Nullable
    private final CohereTruncateType truncate;
    public static final JsonpDeserializer<CohereTaskSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CohereTaskSettings::setupCohereTaskSettingsDeserializer);

    private CohereTaskSettings(Builder builder) {
        this.inputType = builder.inputType;
        this.returnDocuments = builder.returnDocuments;
        this.topN = builder.topN;
        this.truncate = builder.truncate;
    }

    public static CohereTaskSettings of(Function<Builder, ObjectBuilder<CohereTaskSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final CohereInputType inputType() {
        return this.inputType;
    }

    @Nullable
    public final Boolean returnDocuments() {
        return this.returnDocuments;
    }

    @Nullable
    public final Integer topN() {
        return this.topN;
    }

    @Nullable
    public final CohereTruncateType truncate() {
        return this.truncate;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.inputType != null) {
            generator.writeKey("input_type");
            this.inputType.serialize(generator, mapper);
        }
        if (this.returnDocuments != null) {
            generator.writeKey("return_documents");
            generator.write(this.returnDocuments);
        }
        if (this.topN != null) {
            generator.writeKey("top_n");
            generator.write(this.topN);
        }
        if (this.truncate != null) {
            generator.writeKey("truncate");
            this.truncate.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCohereTaskSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::inputType, CohereInputType._DESERIALIZER, "input_type");
        op.add(Builder::returnDocuments, JsonpDeserializer.booleanDeserializer(), "return_documents");
        op.add(Builder::topN, JsonpDeserializer.integerDeserializer(), "top_n");
        op.add(Builder::truncate, CohereTruncateType._DESERIALIZER, "truncate");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CohereTaskSettings> {
        @Nullable
        private CohereInputType inputType;
        @Nullable
        private Boolean returnDocuments;
        @Nullable
        private Integer topN;
        @Nullable
        private CohereTruncateType truncate;

        public final Builder inputType(@Nullable CohereInputType value) {
            this.inputType = value;
            return this;
        }

        public final Builder returnDocuments(@Nullable Boolean value) {
            this.returnDocuments = value;
            return this;
        }

        public final Builder topN(@Nullable Integer value) {
            this.topN = value;
            return this;
        }

        public final Builder truncate(@Nullable CohereTruncateType value) {
            this.truncate = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CohereTaskSettings build() {
            this._checkSingleUse();
            return new CohereTaskSettings(this);
        }
    }
}

