/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MergeScheduler
implements JsonpSerializable {
    @Nullable
    private final Integer maxThreadCount;
    @Nullable
    private final Integer maxMergeCount;
    public static final JsonpDeserializer<MergeScheduler> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MergeScheduler::setupMergeSchedulerDeserializer);

    private MergeScheduler(Builder builder) {
        this.maxThreadCount = builder.maxThreadCount;
        this.maxMergeCount = builder.maxMergeCount;
    }

    public static MergeScheduler of(Function<Builder, ObjectBuilder<MergeScheduler>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer maxThreadCount() {
        return this.maxThreadCount;
    }

    @Nullable
    public final Integer maxMergeCount() {
        return this.maxMergeCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxThreadCount != null) {
            generator.writeKey("max_thread_count");
            generator.write(this.maxThreadCount);
        }
        if (this.maxMergeCount != null) {
            generator.writeKey("max_merge_count");
            generator.write(this.maxMergeCount);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupMergeSchedulerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxThreadCount, JsonpDeserializer.integerDeserializer(), "max_thread_count");
        op.add(Builder::maxMergeCount, JsonpDeserializer.integerDeserializer(), "max_merge_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MergeScheduler> {
        @Nullable
        private Integer maxThreadCount;
        @Nullable
        private Integer maxMergeCount;

        public final Builder maxThreadCount(@Nullable Integer value) {
            this.maxThreadCount = value;
            return this;
        }

        public final Builder maxMergeCount(@Nullable Integer value) {
            this.maxMergeCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MergeScheduler build() {
            this._checkSingleUse();
            return new MergeScheduler(this);
        }
    }
}

