"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecuritySolutionStartDependencies = exports.SecuritySolutionStartDependenciesContext = void 0;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * For use with the Fleet UI extensions, where `useKibana().services.**` does not return the services
 * provided to the Security Solution plugin.
 */
const SecuritySolutionStartDependenciesContext = exports.SecuritySolutionStartDependenciesContext = /*#__PURE__*/_react.default.createContext(undefined);

/**
 * Hook used in `useEndpointPrivileges()` when that hook is being invoked from outside of
 * security solution, as is the case with UI extensions that are rendered within the Fleet
 * pages.
 */
const useSecuritySolutionStartDependencies = () => {
  return (0, _react.useContext)(SecuritySolutionStartDependenciesContext);
};
exports.useSecuritySolutionStartDependencies = useSecuritySolutionStartDependencies;