"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ATTACK_DISCOVERY_STATS_MESSAGE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ATTACK_DISCOVERY_STATS_MESSAGE = ({
  newConnectorResultsCount,
  newDiscoveriesCount
}) => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.pageTitle.statusConnectors', {
  values: {
    newConnectorResultsCount,
    newDiscoveriesCount
  },
  defaultMessage: 'You have {newDiscoveriesCount} new {newDiscoveriesCount, plural, =1 {discovery} other {discoveries}} across {newConnectorResultsCount} {newConnectorResultsCount, plural, =1 {connector} other {connectors}} to view.'
});
exports.ATTACK_DISCOVERY_STATS_MESSAGE = ATTACK_DISCOVERY_STATS_MESSAGE;