"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HoverForExplanationTooltip = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A component that adds a tooltip to its children and adds an underline to indicate that
 * the children can be hovered for more information.
 */
const HoverForExplanationTooltip = ({
  children,
  ...rest
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, rest, /*#__PURE__*/_react.default.createElement("u", {
    css: (0, _react2.css)`
          text-decoration: underline;
          text-decoration-style: dotted;
          text-underline-offset: ${euiTheme.size.xs};
        `
  }, children));
};
exports.HoverForExplanationTooltip = HoverForExplanationTooltip;