"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CloudAssetInventoryPolicyTemplateForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/fleet-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _gte = _interopRequireDefault(require("semver/functions/gte"));
var _utils = require("./utils");
var _setup_technology_selector = require("./setup_technology_selector/setup_technology_selector");
var _use_setup_technology = require("./setup_technology_selector/use_setup_technology");
var _policy_template_selectors = require("./policy_template_selectors");
var _aws_account_type_select = require("./aws_credentials_form/aws_account_type_select");
var _constants = require("./aws_credentials_form/constants");
var _gcp_account_type_select = require("./gcp_credentials_form/gcp_account_type_select");
var _azure_account_type_select = require("./azure_credentials_form/azure_account_type_select");
var _hooks = require("./hooks");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// // import { useIsSubscriptionStatusValid } from '../../common/hooks/use_is_subscription_status_valid';
// // import { SubscriptionNotAllowed } from '../subscription_not_allowed';

const EditScreenStepTitle = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.assetInventory.fleetIntegration.integrationSettingsTitle",
  defaultMessage: "Integration Settings"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
const IntegrationSettings = ({
  onChange,
  fields
}) => /*#__PURE__*/_react.default.createElement("div", null, fields.map(({
  value,
  id,
  label,
  error
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  key: id,
  id: id,
  fullWidth: true,
  label: label,
  isInvalid: !!error,
  error: error
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
  isInvalid: !!error,
  fullWidth: true,
  value: value,
  onChange: event => onChange(id, event.target.value)
}))));
const getSelectedOption = options => {
  // Looks for the enabled deployment (aka input). By default, all inputs are disabled.
  // Initial state when all inputs are disabled is to choose the first available of the relevant policyTemplate
  const selectedOption = options.find(i => i.enabled) || options[0];
  return selectedOption;
};
const CloudAssetInventoryPolicyTemplateForm = exports.default = exports.CloudAssetInventoryPolicyTemplateForm = /*#__PURE__*/(0, _react.memo)(({
  newPolicy,
  onChange,
  validationResults,
  isEditPage,
  packageInfo,
  handleSetupTechnologyChange,
  isAgentlessEnabled,
  defaultSetupTechnology
}) => {
  const CLOUD_CONNECTOR_VERSION_ENABLED_ESS = '0.18.0';
  const {
    cloud,
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const input = getSelectedOption(newPolicy.inputs);
  const {
    isAgentlessAvailable,
    setupTechnology,
    updateSetupTechnology
  } = (0, _use_setup_technology.useSetupTechnology)({
    input,
    isAgentlessEnabled,
    handleSetupTechnologyChange,
    isEditPage,
    defaultSetupTechnology
  });
  const shouldRenderAgentlessSelector = !isEditPage && isAgentlessAvailable || isEditPage && isAgentlessEnabled;
  const updatePolicy = (0, _react.useCallback)(updatedPolicy => {
    onChange({
      isValid: true,
      updatedPolicy
    });
  }, [onChange]);
  const cloudConnectorsEnabled = uiSettings.get(_managementSettingsIds.SECURITY_SOLUTION_ENABLE_CLOUD_CONNECTOR_SETTING) || false;
  const cloudConnectorRemoteRoleTemplate = (0, _utils.getCloudConnectorRemoteRoleTemplate)({
    input,
    cloud,
    packageInfo
  });
  const showCloudConnectors = cloudConnectorsEnabled && !!cloudConnectorRemoteRoleTemplate && (0, _gte.default)(packageInfo.version, CLOUD_CONNECTOR_VERSION_ENABLED_ESS) && setupTechnology === _public.SetupTechnology.AGENTLESS;

  // /**
  //  * - Updates policy inputs by user selection
  //  * - Updates hidden policy vars
  //  */
  const setEnabledPolicyInput = (0, _react.useCallback)(inputType => {
    const inputVars = (0, _utils.getAssetInputHiddenVars)(inputType, packageInfo, setupTechnology, showCloudConnectors);
    const policy = (0, _utils.getAssetPolicy)(newPolicy, inputType, inputVars);
    updatePolicy(policy);
  }, [packageInfo, setupTechnology, showCloudConnectors, newPolicy, updatePolicy]);

  // // search for non null fields of the validation?.vars object
  const validationResultsNonNullFields = Object.keys((validationResults === null || validationResults === void 0 ? void 0 : validationResults.vars) || {}).filter(key => ((validationResults === null || validationResults === void 0 ? void 0 : validationResults.vars) || {})[key] !== null);
  const hasInvalidRequiredVars = !!(0, _utils.hasErrors)(validationResults);
  const [isLoading, setIsLoading] = (0, _react.useState)(validationResultsNonNullFields.length > 0);
  (0, _react.useEffect)(() => {
    // using validation?.vars to know if the newPolicy state was reset due to race condition
    if (validationResultsNonNullFields.length > 0) {
      // Forcing rerender to recover from the validation errors state
      setIsLoading(true);
    }
  }, [validationResultsNonNullFields]);
  (0, _react.useEffect)(() => {
    if (isEditPage) return;
    if (isLoading) return;
    // Pick default input type for policy template.
    // Only 1 enabled input is supported when all inputs are initially enabled.
    // Required for mount only to ensure a single input type is selected
    // This will remove errors in validationResults.vars
    setEnabledPolicyInput(input.type);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isLoading, input.policy_template, isEditPage]);
  (0, _hooks.useEnsureDefaultNamespace)({
    newPolicy,
    input,
    updatePolicy
  });
  const integrationFields = [{
    id: 'name',
    value: newPolicy.name,
    error: (validationResults === null || validationResults === void 0 ? void 0 : validationResults.name) || null,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.fleetIntegration.integrationNameLabel",
      defaultMessage: "Name"
    })
  }, {
    id: 'description',
    value: newPolicy.description || '',
    error: (validationResults === null || validationResults === void 0 ? void 0 : validationResults.description) || null,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.fleetIntegration.integrationDescriptionLabel",
      defaultMessage: "Description"
    })
  }];

  // if (!getIsSubscriptionValid.isLoading && !isSubscriptionValid) {
  //   return <SubscriptionNotAllowed />;
  // }

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEditPage && /*#__PURE__*/_react.default.createElement(EditScreenStepTitle, null), isEditPage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.editWarning.calloutTitle', {
      defaultMessage: 'Modifying Integration Details'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.editWarning.calloutDescription",
    defaultMessage: "In order to change the cloud service provider (CSP) you want to monitor, add more accounts, or change where Cloud Asset Discovery is deployed (Organization vs Single Account), please add a new Cloud Asset Discovery integration."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.configureAssetIntegrationDescription",
    defaultMessage: "Select the cloud service provider (CSP) you want to monitor and then fill in the name and description to help identify this integration"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_policy_template_selectors.PolicyTemplateInputSelector, {
    input: input,
    setInput: setEnabledPolicyInput,
    disabled: isEditPage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), input.type === _constants.CLOUDBEAT_AWS && /*#__PURE__*/_react.default.createElement(_aws_account_type_select.AwsAccountTypeSelect, {
    input: input,
    newPolicy: newPolicy,
    updatePolicy: updatePolicy,
    disabled: isEditPage
  }), input.type === 'cloudbeat/asset_inventory_gcp' && /*#__PURE__*/_react.default.createElement(_gcp_account_type_select.GcpAccountTypeSelect, {
    input: input,
    newPolicy: newPolicy,
    updatePolicy: updatePolicy,
    disabled: isEditPage
  }), input.type === 'cloudbeat/asset_inventory_azure' && /*#__PURE__*/_react.default.createElement(_azure_account_type_select.AzureAccountTypeSelect, {
    input: input,
    newPolicy: newPolicy,
    updatePolicy: updatePolicy,
    disabled: isEditPage,
    setupTechnology: setupTechnology
  }), /*#__PURE__*/_react.default.createElement(IntegrationSettings, {
    fields: integrationFields,
    onChange: (field, value) => updatePolicy({
      ...newPolicy,
      [field]: value
    })
  }), shouldRenderAgentlessSelector && /*#__PURE__*/_react.default.createElement(_setup_technology_selector.SetupTechnologySelector, {
    disabled: isEditPage,
    setupTechnology: setupTechnology,
    onSetupTechnologyChange: value => {
      updateSetupTechnology(value);
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, (0, _utils.getDefaultCloudCredentialsType)(value === _public.SetupTechnology.AGENTLESS, input.type)));
    }
  }), /*#__PURE__*/_react.default.createElement(_policy_template_selectors.PolicyTemplateVarsForm, {
    input: input,
    newPolicy: newPolicy,
    updatePolicy: updatePolicy,
    packageInfo: packageInfo,
    disabled: isEditPage,
    setupTechnology: setupTechnology,
    isEditPage: isEditPage,
    hasInvalidRequiredVars: hasInvalidRequiredVars,
    showCloudConnectors: showCloudConnectors
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
});
CloudAssetInventoryPolicyTemplateForm.displayName = 'CloudAssetInventoryPolicyTemplateForm';

// eslint-disable-next-line import/no-default-export