"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQueryRulesSetsTableData = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useQueryRulesSetsTableData = (endpointData, searchKey, pageIndex, pageSize) => {
  var _endpointData$_meta2;
  const data = endpointData === null || endpointData === void 0 ? void 0 : endpointData.data;
  const queryRulesSetsFilteredData = (0, _react.useMemo)(() => {
    if (!data) return [];
    return data.filter(item => item.ruleset_id.toLowerCase().includes(searchKey.toLowerCase()));
  }, [data, searchKey]);
  const pagination = (0, _react.useMemo)(() => {
    var _endpointData$_meta;
    return {
      pageIndex,
      pageSize,
      totalItemCount: (endpointData === null || endpointData === void 0 ? void 0 : (_endpointData$_meta = endpointData._meta) === null || _endpointData$_meta === void 0 ? void 0 : _endpointData$_meta.totalItemCount) || 0,
      pageSizeOptions: [10, 25, 50]
    };
  }, [pageIndex, pageSize, endpointData === null || endpointData === void 0 ? void 0 : (_endpointData$_meta2 = endpointData._meta) === null || _endpointData$_meta2 === void 0 ? void 0 : _endpointData$_meta2.totalItemCount]);
  return {
    queryRulesSetsFilteredData,
    pagination
  };
};
exports.useQueryRulesSetsTableData = useQueryRulesSetsTableData;