"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchPlaygroundSetupPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_query_indices = require("../../hooks/use_query_indices");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
var _playground_body_section = require("../playground_body_section");
var _add_data_sources = require("./add_data_sources");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchPlaygroundSetupPage = () => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    isLoading: isIndicesLoading
  } = (0, _use_query_indices.useQueryIndices)();
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.setupSearchPageLoaded);
  }, [usageTracker]);
  return /*#__PURE__*/_react.default.createElement(_playground_body_section.PlaygroundBodySection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "indexOpen",
    "data-test-subj": "setupPage",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.setupPage.queryBuilder.title",
      defaultMessage: "Add data to query"
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, isIndicesLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_add_data_sources.AddDataSources, null))),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.setupPage.learnMore",
      defaultMessage: "Want to learn more?"
    }))), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "todo",
      target: "_blank",
      "data-test-subj": "search-playground-setup-documentationLink",
      external: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.setupPage.documentationLink",
      defaultMessage: "Read documentation"
    })))
  }));
};
exports.SearchPlaygroundSetupPage = SearchPlaygroundSetupPage;