"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchHomePageRedirect = void 0;
var _react = require("react");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _use_indices_status_query = require("./api/use_indices_status_query");
var _use_user_permissions = require("./api/use_user_permissions");
var _indices = require("../utils/indices");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSearchHomePageRedirect = () => {
  const {
    application,
    http
  } = (0, _use_kibana.useKibana)().services;
  const indexName = (0, _react.useMemo)(() => (0, _indices.generateRandomIndexName)(), []);
  const {
    data: userPrivileges
  } = (0, _use_user_permissions.useUserPrivilegesQuery)(indexName);
  const skipGlobalEmptyState = (0, _react.useMemo)(() => {
    return localStorage.getItem(_searchSharedUi.GLOBAL_EMPTY_STATE_SKIP_KEY) === 'true';
  }, []);
  const {
    data: indicesStatus
  } = (0, _use_indices_status_query.useIndicesStatusQuery)(undefined, !skipGlobalEmptyState);
  const [hasDoneRedirect, setHasDoneRedirect] = (0, _react.useState)(() => false);
  return (0, _react.useEffect)(() => {
    var _userPrivileges$privi;
    if (hasDoneRedirect || skipGlobalEmptyState) {
      return;
    }
    if (!userPrivileges) {
      return;
    }
    if ((userPrivileges === null || userPrivileges === void 0 ? void 0 : (_userPrivileges$privi = userPrivileges.privileges) === null || _userPrivileges$privi === void 0 ? void 0 : _userPrivileges$privi.canManageIndex) === false) {
      setHasDoneRedirect(true);
      return;
    }
    if (!indicesStatus) {
      return;
    }
    if (indicesStatus.indexNames.length === 0) {
      application.navigateToApp('elasticsearchStart');
      setHasDoneRedirect(true);
      return;
    }
    setHasDoneRedirect(true);
  }, [application, http, indicesStatus, setHasDoneRedirect, hasDoneRedirect, userPrivileges, skipGlobalEmptyState]);
};
exports.useSearchHomePageRedirect = useSearchHomePageRedirect;