"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Observability = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
var _doc_links = require("../../../common/doc_links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Observability = () => {
  var _cloud$isServerlessEn;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    http,
    cloud
  } = (0, _use_kibana.useKibana)().services;
  const isServerless = (_cloud$isServerlessEn = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) !== null && _cloud$isServerlessEn !== void 0 ? _cloud$isServerlessEn : false;
  const o11yTrialLink = (0, _react.useMemo)(() => {
    if (cloud && cloud.isServerlessEnabled) {
      var _cloud$projectsUrl;
      const baseUrl = (_cloud$projectsUrl = cloud === null || cloud === void 0 ? void 0 : cloud.projectsUrl) !== null && _cloud$projectsUrl !== void 0 ? _cloud$projectsUrl : 'https://cloud.elastic.co/projects/';
      return `${baseUrl}create/observability/start`;
    }
    return http.basePath.prepend('/app/observability/onboarding');
  }, [cloud, http]);
  const o11yCreateSpaceLink = (0, _react.useMemo)(() => {
    return http.basePath.prepend('/app/management/kibana/spaces/create');
  }, [http]);
  const analyzeLogsIntegration = (0, _react.useMemo)(() => {
    return http.basePath.prepend('/app/integrations/browse/observability');
  }, [http]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    "data-test-subj": "observabilitySection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    size: "xl",
    color: "plain",
    name: "Observability",
    iconType: "logoObservability",
    style: {
      border: euiTheme.border.thin
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.searchHomepage.observability.title', {
    defaultMessage: 'Observability'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.searchHomepage.observability.description', {
    defaultMessage: 'Consolidate your logs, metrics, application traces, and system availability with purpose-built UIs.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.searchHomepage.observability.logsTitle', {
    defaultMessage: 'Collect and analyze logs'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isServerless ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.analyzeLogs,
    "data-test-subj": "exploreLogstashAndBeatsLink"
  }, _i18n.i18n.translate('xpack.searchHomepage.observability.exploreLogstashBeats', {
    defaultMessage: 'Explore Logstash and Beats'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: analyzeLogsIntegration,
    "data-test-subj": "analyzeLogsBrowseIntegrations"
  }, _i18n.i18n.translate('xpack.searchHomepage.observability.exploreLogstashBeats', {
    defaultMessage: 'Explore Logstash and Beats'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.searchHomepage.observability.performanceMonitoringTitle', {
    defaultMessage: 'Powerful performance monitoring'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isServerless ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: o11yTrialLink,
    "data-test-subj": "createObservabilityProjectLink"
  }, _i18n.i18n.translate('xpack.searchHomepage.observability.createObservabilityProjectLink', {
    defaultMessage: 'Create an Observability project'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: o11yCreateSpaceLink,
    "data-test-subj": "createObservabilitySpaceLink"
  }, _i18n.i18n.translate('xpack.searchHomepage.observability.createObservabilitySpaceLink', {
    defaultMessage: 'Create an Observability space'
  }))))))))));
};
exports.Observability = Observability;