"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.docLinks = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ESDocLinks {
  constructor() {
    (0, _defineProperty2.default)(this, "kibanaFeedback", '');
    (0, _defineProperty2.default)(this, "elasticCommunity", '');
    (0, _defineProperty2.default)(this, "elasticsearchDocs", '');
    (0, _defineProperty2.default)(this, "visitSearchLabs", '');
    (0, _defineProperty2.default)(this, "notebooksExamples", '');
    (0, _defineProperty2.default)(this, "customerEngineerRequestForm", '');
    (0, _defineProperty2.default)(this, "analyzeLogs", '');
    (0, _defineProperty2.default)(this, "ingestDataToSecurity", '');
    (0, _defineProperty2.default)(this, "cloudSecurityPosture", '');
    (0, _defineProperty2.default)(this, "installElasticDefend", '');
  }
  setDocLinks(newDocLinks) {
    this.kibanaFeedback = newDocLinks.kibana.feedback;
    this.elasticCommunity = newDocLinks.searchHomepage.elasticCommunity;
    this.elasticsearchDocs = newDocLinks.elasticsearch.gettingStarted;
    this.visitSearchLabs = newDocLinks.searchHomepage.visitSearchLabs;
    this.notebooksExamples = newDocLinks.searchHomepage.notebooksExamples;
    this.analyzeLogs = newDocLinks.serverlessSearch.integrations;
    this.customerEngineerRequestForm = newDocLinks.searchHomepage.customerEngineerRequestForm;
    this.ingestDataToSecurity = newDocLinks.siem.ingestDataToSecurity;
    this.cloudSecurityPosture = newDocLinks.securitySolution.cloudSecurityPosture;
    this.installElasticDefend = newDocLinks.securitySolution.installElasticDefend;
  }
}
const docLinks = exports.docLinks = new ESDocLinks();