"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.detailPanel = detailPanel;
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  isOpen: false,
  clusterName: undefined
};
function detailPanel(state = initialState, action) {
  const {
    type,
    payload
  } = action;
  switch (type) {
    case _action_types.OPEN_DETAIL_PANEL:
      const {
        clusterName
      } = payload;
      return {
        clusterName,
        isOpen: true
      };
    case _action_types.CLOSE_DETAIL_PANEL:
      return {
        clusterName: undefined,
        isOpen: false
      };
    default:
      return state;
  }
}