"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndicesForProductNames = void 0;
var _productDocCommon = require("@kbn/product-doc-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndicesForProductNames = (productNames, inferenceId) => {
  if (!productNames || !productNames.length) {
    return _productDocCommon.productDocIndexPattern;
  }
  return productNames.map(productName => (0, _productDocCommon.getProductDocIndexName)(productName, inferenceId));
};
exports.getIndicesForProductNames = getIndicesForProductNames;