"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AGENT_STATUSES = void 0;
exports.getColorForAgentStatus = getColorForAgentStatus;
exports.getLabelForAgentStatus = getLabelForAgentStatus;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const visColors = (0, _eui.euiPaletteColorBlindBehindText)();
const colorToHexMap = {
  default: '#d3dae6',
  primary: visColors[1],
  success: visColors[0],
  accent: visColors[2],
  warning: visColors[5],
  danger: visColors[9]
};
const AGENT_STATUSES = exports.AGENT_STATUSES = [_types.ActionAgentStatus.SUCCESS, _types.ActionAgentStatus.PENDING, _types.ActionAgentStatus.FAILED];
function getColorForAgentStatus(agentStatus) {
  switch (agentStatus) {
    case _types.ActionAgentStatus.SUCCESS:
      return colorToHexMap.success;
    case _types.ActionAgentStatus.PENDING:
      return colorToHexMap.default;
    case _types.ActionAgentStatus.FAILED:
      return colorToHexMap.danger;
    default:
      throw new Error(`Unsupported action agent status ${agentStatus}`);
  }
}
function getLabelForAgentStatus(agentStatus, expired) {
  switch (agentStatus) {
    case _types.ActionAgentStatus.SUCCESS:
      return _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.summary.successfulLabelText', {
        defaultMessage: 'Successful'
      });
    case _types.ActionAgentStatus.PENDING:
      return expired ? _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.summary.expiredLabelText', {
        defaultMessage: 'Expired'
      }) : _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.summary.pendingLabelText', {
        defaultMessage: 'Not yet responded'
      });
    case _types.ActionAgentStatus.FAILED:
      return _i18n.i18n.translate('xpack.osquery.liveQueryActionResults.summary.failedLabelText', {
        defaultMessage: 'Failed'
      });
    default:
      throw new Error(`Unsupported action agent status ${agentStatus}`);
  }
}