"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexMappings = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndexMappings = async ({
  indices,
  cleanup = true,
  esClient
}) => {
  const response = await esClient.indices.getMapping({
    index: indices
  });
  return Object.entries(response).reduce((res, [indexName, mappingRes]) => {
    res[indexName] = {
      mappings: cleanup ? (0, _utils.cleanupMapping)(mappingRes.mappings) : mappingRes.mappings
    };
    return res;
  }, {});
};
exports.getIndexMappings = getIndexMappings;