"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLastValueAggBucketScript = exports.createLastValueAggBucket = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLastValueAggBucketScript = (key, field) => {
  return {
    [key]: {
      bucket_script: {
        buckets_path: {
          last_value: `_${key}>last_value[${field}]`
        },
        script: `params.last_value`
      }
    }
  };
};
exports.createLastValueAggBucketScript = createLastValueAggBucketScript;
const createLastValueAggBucket = (key, timeFieldName, field) => {
  return {
    [`_${key}`]: {
      filter: {
        bool: {
          must: [{
            exists: {
              field
            }
          }]
        }
      },
      aggs: {
        last_value: {
          top_metrics: {
            metrics: {
              field
            },
            sort: {
              [timeFieldName]: 'desc'
            }
          }
        }
      }
    }
  };
};
exports.createLastValueAggBucket = createLastValueAggBucket;