"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.firehoseOnboardingRouteRepository = void 0;
var _uuid = require("uuid");
var _boom = _interopRequireDefault(require("@hapi/boom"));
var t = _interopRequireWildcard(require("io-ts"));
var _server = require("@kbn/observability-plugin/server");
var _aws_firehose = require("../../../common/aws_firehose");
var _get_fallback_urls = require("../../lib/get_fallback_urls");
var _create_observability_onboarding_server_route = require("../create_observability_onboarding_server_route");
var _has_log_monitoring_privileges = require("../../lib/api_key/has_log_monitoring_privileges");
var _create_shipper_api_key = require("../../lib/api_key/create_shipper_api_key");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFirehoseOnboardingFlowRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'POST /internal/observability_onboarding/firehose/flow',
  security: {
    authz: {
      enabled: false,
      reason: 'This route has custom authorization logic using Elasticsearch client'
    }
  },
  async handler({
    context,
    request,
    plugins,
    services,
    logger
  }) {
    var _plugins$cloud, _plugins$cloud$setup, _plugins$cloud2, _plugins$cloud2$setup;
    const {
      elasticsearch: {
        client
      }
    } = await context.core;
    const hasPrivileges = await (0, _has_log_monitoring_privileges.hasLogMonitoringPrivileges)(client.asCurrentUser);
    if (!hasPrivileges) {
      throw _boom.default.forbidden("You don't have enough privileges to start a new onboarding flow. Contact your system administrator to grant you the required privileges.");
    }
    const fleetPluginStart = await plugins.fleet.start();
    const packageClient = fleetPluginStart.packageService.asScoped(request);
    const [{
      encoded: apiKeyEncoded
    }] = await Promise.all([(0, _create_shipper_api_key.createShipperApiKey)(client.asCurrentUser, 'firehose'), packageClient.ensureInstalledPackage({
      pkgName: 'awsfirehose'
    })]);

    /**
     * Triggering the AWS package installation but not
     * waiting for the completion as it might take a while.
     * The AWS integration is not required for data ingestion
     * and can be installed separately in case it fails to install
     * during onboarding.
     */
    packageClient.ensureInstalledPackage({
      pkgName: 'aws'
    }).catch(error => {
      logger.error(`Failed installing AWS package: ${error}`);
    });
    const elasticsearchUrlList = (_plugins$cloud = plugins.cloud) !== null && _plugins$cloud !== void 0 && (_plugins$cloud$setup = _plugins$cloud.setup) !== null && _plugins$cloud$setup !== void 0 && _plugins$cloud$setup.elasticsearchUrl ? [(_plugins$cloud2 = plugins.cloud) === null || _plugins$cloud2 === void 0 ? void 0 : (_plugins$cloud2$setup = _plugins$cloud2.setup) === null || _plugins$cloud2$setup === void 0 ? void 0 : _plugins$cloud2$setup.elasticsearchUrl] : await (0, _get_fallback_urls.getFallbackESUrl)(services.esLegacyConfigService);
    return {
      onboardingId: (0, _uuid.v4)(),
      apiKeyEncoded,
      elasticsearchUrl: elasticsearchUrlList.length > 0 ? elasticsearchUrlList[0] : '',
      templateUrl: _aws_firehose.FIREHOSE_CLOUDFORMATION_TEMPLATE_URL
    };
  }
});
const hasFirehoseDataRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'GET /internal/observability_onboarding/firehose/has-data',
  params: t.type({
    query: t.type({
      streamName: t.string,
      stackName: t.string
    })
  }),
  security: {
    authz: {
      enabled: false,
      reason: 'Authorization is checked by Elasticsearch client'
    }
  },
  async handler(resources) {
    const {
      streamName,
      stackName
    } = resources.params.query;
    const {
      elasticsearch
    } = await resources.context.core;
    const indexPatternList = _aws_firehose.AWS_INDEX_NAME_LIST.map(index => `${index}-*`);
    try {
      var _result$aggregations;
      const result = await elasticsearch.client.asCurrentUser.search({
        index: indexPatternList,
        ignore_unavailable: true,
        size: 0,
        query: {
          bool: {
            should: [...(0, _server.termQuery)('aws.kinesis.name', streamName), ...(0, _server.wildcardQuery)('aws.exporter.arn', stackName)]
          }
        },
        aggs: {
          documents_per_index: {
            terms: {
              field: '_index',
              size: indexPatternList.length
            }
          }
        }
      });
      const buckets = (_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : _result$aggregations.documents_per_index.buckets;
      if (!Array.isArray(buckets)) {
        return [];
      }
      return _aws_firehose.AWS_INDEX_NAME_LIST.filter(indexName => {
        return buckets.some(bucket => bucket.key.includes(indexName) && bucket.doc_count > 0);
      });
    } catch (error) {
      throw _boom.default.internal(`Elasticsearch responded with an error. ${error.message}`);
    }
  }
});
const firehoseOnboardingRouteRepository = exports.firehoseOnboardingRouteRepository = {
  ...createFirehoseOnboardingFlowRoute,
  ...hasFirehoseDataRoute
};