"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootCauseAnalysisStepItem = RootCauseAnalysisStepItem;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _rca_panel = require("../rca_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RootCauseAnalysisStepItem({
  label,
  loading,
  color,
  iconType,
  button
}) {
  return /*#__PURE__*/_react.default.createElement(_rca_panel.RootCauseAnalysisPanel, {
    color: color
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexStart",
    justifyContent: "flexStart",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: (0, _css.css)`
              min-height: 40px;
            `,
    justifyContent: "center",
    alignItems: "center"
  }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType || 'logoElastic'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    className: (0, _css.css)`
              min-height: 40px;
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, label))), button ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, button) : null));
}