"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelStatusIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _trained_models = require("../../../common/types/trained_models");
var _get_model_state = require("./get_model_state");
var _kibana = require("../contexts/kibana");
var _check_capabilities = require("../capabilities/check_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ModelStatusIndicator = ({
  modelId,
  configOverrides
}) => {
  var _downloadState$downlo, _downloadState$total_, _config$component;
  const {
    services: {
      mlServices: {
        trainedModelsService
      }
    }
  } = (0, _kibana.useMlKibana)();
  const [canStartStopTrainedModels] = (0, _check_capabilities.usePermissionCheck)(['canStartStopTrainedModels']);
  const currentModel = (0, _useObservable.default)(trainedModelsService.getModel$(modelId), trainedModelsService.getModel(modelId));
  if (!currentModel || !(0, _trained_models.isBaseNLPModelItem)(currentModel)) {
    return null;
  }
  const {
    state,
    downloadState
  } = currentModel;
  const config = (0, _get_model_state.getModelStateColor)(state, canStartStopTrainedModels, configOverrides === null || configOverrides === void 0 ? void 0 : configOverrides.names);
  if (!config) {
    return null;
  }
  const isProgressbarVisible = state === _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADING && downloadState;
  const label = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: config.color
  }, config.name);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    gutterSize: 'none',
    css: {
      width: '100%'
    }
  }, isProgressbarVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    label: config.name,
    labelProps: {
      ...((configOverrides === null || configOverrides === void 0 ? void 0 : configOverrides.color) && {
        css: {
          color: configOverrides.color
        }
      })
    },
    valueText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, downloadState ? (downloadState.downloaded_parts / (downloadState.total_parts || -1) * 100).toFixed(0) + '%' : '100%'),
    value: (_downloadState$downlo = downloadState === null || downloadState === void 0 ? void 0 : downloadState.downloaded_parts) !== null && _downloadState$downlo !== void 0 ? _downloadState$downlo : 1,
    max: (_downloadState$total_ = downloadState === null || downloadState === void 0 ? void 0 : downloadState.total_parts) !== null && _downloadState$total_ !== void 0 ? _downloadState$total_ : 1,
    size: "xs",
    color: config.color
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, (_config$component = config.component) !== null && _config$component !== void 0 ? _config$component : label)));
};
exports.ModelStatusIndicator = ModelStatusIndicator;