"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _module_jobs = require("./module_jobs");
var _group_color_utils = require("../../../../../../common/util/group_color_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobItem = exports.JobItem = /*#__PURE__*/(0, _react.memo)(({
  job,
  jobOverride,
  isSaving,
  jobPrefix,
  onEditRequest
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    id,
    config: {
      description,
      groups
    },
    datafeedResult,
    setupResult
  } = job;
  const jobGroups = jobOverride && jobOverride.groups || groups;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "accentSecondary"
  }, jobPrefix, id)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.job.overrideJobConfigurationLabel",
      defaultMessage: "Override job configuration"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.recognize.job.overrideJobConfigurationLabel', {
      defaultMessage: 'Override job configuration'
    }),
    iconType: "pencil",
    onClick: () => onEditRequest(job)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, description), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    gutterSize: "xs"
  }, (jobGroups !== null && jobGroups !== void 0 ? jobGroups : []).map(group => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: group
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: (0, _group_color_utils.tabColor)(group, euiTheme)
  }, group)))), setupResult && setupResult.error && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, (0, _mlErrorUtils.extractErrorMessage)(setupResult.error)), datafeedResult && datafeedResult.error && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, (0, _mlErrorUtils.extractErrorMessage)(datafeedResult.error))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: _module_jobs.SETUP_RESULTS_WIDTH
    }
  }, isSaving && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }), setupResult && datafeedResult && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: false,
    responsive: false,
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: setupResult.success ? 'check' : 'cross',
    color: setupResult.success ? 'success' : 'danger',
    size: "m",
    "aria-label": setupResult.success ? _i18n.i18n.translate('xpack.ml.newJob.recognize.job.savedAriaLabel', {
      defaultMessage: 'Saved'
    }) : _i18n.i18n.translate('xpack.ml.newJob.recognize.job.saveFailedAriaLabel', {
      defaultMessage: 'Save failed'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: datafeedResult.success ? 'check' : 'cross',
    color: datafeedResult.success ? 'success' : 'danger',
    size: "m",
    "aria-label": setupResult.success ? _i18n.i18n.translate('xpack.ml.newJob.recognize.datafeed.savedAriaLabel', {
      defaultMessage: 'Saved'
    }) : _i18n.i18n.translate('xpack.ml.newJob.recognize.datafeed.saveFailedAriaLabel', {
      defaultMessage: 'Save failed'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: getDatafeedStartedIcon(datafeedResult).type,
    color: getDatafeedStartedIcon(datafeedResult).color,
    size: "m",
    "aria-label": setupResult.success ? _i18n.i18n.translate('xpack.ml.newJob.recognize.running.startedAriaLabel', {
      defaultMessage: 'Started'
    }) : _i18n.i18n.translate('xpack.ml.newJob.recognize.running.startFailedAriaLabel', {
      defaultMessage: 'Start failed'
    })
  })))));
});
function getDatafeedStartedIcon({
  awaitingMlNodeAllocation,
  success
}) {
  if (awaitingMlNodeAllocation === true) {
    return {
      type: 'warning',
      color: 'warning'
    };
  }
  return success ? {
    type: 'check',
    color: 'success'
  } : {
    type: 'cross',
    color: 'danger'
  };
}