"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getScatterplotMatrixLegendType = void 0;
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _common = require("../../components/vega_chart/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getScatterplotMatrixLegendType = jobType => {
  switch (jobType) {
    case _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION:
      return _common.LEGEND_TYPES.NOMINAL;
    case _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION:
      return _common.LEGEND_TYPES.QUANTITATIVE;
    default:
      return undefined;
  }
};
exports.getScatterplotMatrixLegendType = getScatterplotMatrixLegendType;