"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StaticOrientationForm = StaticOrientationForm;
var _react = _interopRequireDefault(require("react"));
var _validated_range = require("../../../../../components/validated_range");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StaticOrientationForm({
  onStaticStyleChange,
  staticDynamicSelect,
  styleProperty
}) {
  const onOrientationChange = orientation => {
    onStaticStyleChange(styleProperty.getStyleName(), {
      orientation
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "mapStyleSettings__fixedBox"
  }, staticDynamicSelect), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_validated_range.ValidatedRange, {
    min: 0,
    max: 360,
    value: styleProperty.getOptions().orientation,
    onChange: onOrientationChange,
    showInput: "inputWithPopover",
    showLabels: true,
    compressed: true,
    append: "\xB0"
  })));
}