"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSourceEditor = CreateSourceEditor;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _util = require("../../../util");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CreateSourceEditor({
  onSourceConfigChange
}) {
  const tilemap = (0, _util.getKibanaTileMap)();
  (0, _react.useEffect)(() => {
    if (tilemap.url) {
      onSourceConfigChange();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.source.kbnTMS.kbnTMS.urlLabel', {
      defaultMessage: 'Tilemap url'
    }),
    helpText: tilemap.url ? null : _i18n.i18n.translate('xpack.maps.source.kbnTMS.noLayerAvailableHelptext', {
      defaultMessage: 'No tilemap layer is available. Ask your system administrator to set "map.tilemap.url" in kibana.yml.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    readOnly: true,
    value: tilemap.url ? tilemap.url : ''
  })));
}
CreateSourceEditor.propTypes = {
  onSourceConfigChange: _propTypes.default.func.isRequired
};