"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogEntryRowWrapper = void 0;
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _with_attrs = require("../../../utils/theme_utils/with_attrs");
var _text_styles = require("./text_styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogEntryRowWrapper = exports.LogEntryRowWrapper = (0, _with_attrs.withAttrs)(_styled.default.div`
    align-items: stretch;
    color: ${props => props.theme.euiTheme.colors.textParagraph};
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
    justify-content: flex-start;
    overflow: hidden;

    ${props => (0, _text_styles.useMonospaceTextStyle)(props.scale, props.theme.euiTheme)};
    ${props => props.isHighlighted ? (0, _text_styles.highlightedContentStyle)(props.theme.euiTheme) : ''}

    &:hover {
      ${props => (0, _text_styles.hoveredContentStyle)(props.theme.euiTheme)}
    }
  `, () => ({
  role: 'row'
}));
// eslint-disable-next-line import/no-default-export
var _default = exports.default = LogEntryRowWrapper;