"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = exports.lensSearchOptionsSchema = exports.lensSavedObjectSchema = exports.lensCreateOptionsSchema = exports.lensAttributesSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apiError = _configSchema.schema.object({
  error: _configSchema.schema.string(),
  message: _configSchema.schema.string(),
  statusCode: _configSchema.schema.number(),
  metadata: _configSchema.schema.object({}, {
    unknowns: 'allow'
  })
});
const referenceSchema = _configSchema.schema.object({
  name: _configSchema.schema.maybe(_configSchema.schema.string()),
  type: _configSchema.schema.string(),
  id: _configSchema.schema.string()
}, {
  unknowns: 'forbid'
});
const referencesSchema = _configSchema.schema.arrayOf(referenceSchema);
const lensAttributesSchema = exports.lensAttributesSchema = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  description: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  visualizationType: _configSchema.schema.maybe(_configSchema.schema.string()),
  state: _configSchema.schema.maybe(_configSchema.schema.any()),
  uiStateJSON: _configSchema.schema.maybe(_configSchema.schema.string()),
  visState: _configSchema.schema.maybe(_configSchema.schema.string()),
  savedSearchRefName: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'forbid'
});
const lensSavedObjectSchema = exports.lensSavedObjectSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  version: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdAt: _configSchema.schema.maybe(_configSchema.schema.string()),
  updatedAt: _configSchema.schema.maybe(_configSchema.schema.string()),
  error: _configSchema.schema.maybe(apiError),
  attributes: lensAttributesSchema,
  references: referencesSchema,
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  originId: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'allow'
});
const lensGetResultSchema = _configSchema.schema.object({
  item: lensSavedObjectSchema,
  meta: _configSchema.schema.object({
    outcome: _configSchema.schema.oneOf([_configSchema.schema.literal('exactMatch'), _configSchema.schema.literal('aliasMatch'), _configSchema.schema.literal('conflict')]),
    aliasTargetId: _configSchema.schema.maybe(_configSchema.schema.string()),
    aliasPurpose: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('savedObjectConversion'), _configSchema.schema.literal('savedObjectImport')]))
  }, {
    unknowns: 'forbid'
  })
}, {
  unknowns: 'forbid'
});
const lensCreateOptionsSchema = exports.lensCreateOptionsSchema = _configSchema.schema.object({
  overwrite: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  references: _configSchema.schema.maybe(referencesSchema)
});
const lensSearchOptionsSchema = exports.lensSearchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  searchFields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  types: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
}, {
  unknowns: 'forbid'
}));
const lensCreateResultSchema = _configSchema.schema.object({
  item: lensSavedObjectSchema
}, {
  unknowns: 'forbid'
});

// Content management service definition.
// We need it for BWC support between different versions of the content
const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: lensGetResultSchema
      }
    }
  },
  create: {
    in: {
      data: {
        schema: lensAttributesSchema
      },
      options: {
        schema: lensCreateOptionsSchema
      }
    },
    out: {
      result: {
        schema: lensCreateResultSchema
      }
    }
  },
  update: {
    in: {
      data: {
        schema: lensAttributesSchema
      },
      options: {
        schema: lensCreateOptionsSchema
      }
    },
    out: {
      result: {
        schema: lensCreateResultSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: lensSearchOptionsSchema
      }
    }
  }
};