"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Attachment = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _field_name_field = require("./common_fields/field_name_field");
var _target_field = require("./common_fields/target_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _shared = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const propertyValues = ['content', 'title', 'author', 'keywords', 'date', 'content_type', 'content_length', 'language'];
const fieldsConfig = {
  /* Optional field configs */
  indexed_chars: {
    type: _shared_imports.FIELD_TYPES.NUMBER,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.attachment.indexedCharsFieldLabel', {
      defaultMessage: 'Indexed chars (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.attachment.indexedCharsFieldHelperText",
      defaultMessage: "The number of chars being used for extraction to prevent huge fields. Use -1 for no limit. Defaults to {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '100000')
      }
    })
  },
  indexed_chars_field: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.attachment.indexedCharsFieldFieldLabel', {
      defaultMessage: 'Indexed chars field (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.attachment.indexedCharsFieldFieldHelperText",
      defaultMessage: "Field name from which you can overwrite the number of chars being used for extraction. Defaults to {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'null')
      }
    })
  },
  properties: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    deserializer: _shared.to.arrayOfStrings,
    serializer: _shared.from.optionalArrayOfStrings,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.attachment.propertiesFieldLabel', {
      defaultMessage: 'Properties (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.attachment.propertiesFieldHelperText",
      defaultMessage: " Array of properties to select to be stored. Defaults to {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'all')
      }
    })
  },
  remove_binary: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.attachment.removeBinaryFieldLabel', {
      defaultMessage: 'Remove binary'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.attachment.removeBinaryFieldHelpText', {
      defaultMessage: 'If enabled, the binary field will be removed from the document.'
    })
  },
  resource_name: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.attachment.resourceNameFieldLabel', {
      defaultMessage: 'Resource name (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.attachment.resourceNameFieldHelperText",
      defaultMessage: "Field containing the name of the resource to decode. If specified, the processor passes this resource name to the underlying Tika library to enable Resource Name Based Detection."
    })
  }
};
const Attachment = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.attachment.fieldHelpText",
      defaultMessage: "The field to get the base64 encoded field from."
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.attachment.targetHelpText",
      defaultMessage: "The field that will hold the attachment information. Defaults to {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'attachment')
      }
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "indexedCharsField",
    config: fieldsConfig.indexed_chars,
    component: _shared_imports.Field,
    path: "fields.indexed_chars"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "indexedCharsFieldField",
    config: fieldsConfig.indexed_chars_field,
    component: _shared_imports.Field,
    path: "fields.indexed_chars_field"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.ComboBoxField,
    config: fieldsConfig.properties,
    euiFieldProps: {
      'data-test-subj': 'propertiesField',
      noSuggestions: false,
      options: propertyValues.map(label => ({
        label
      }))
    },
    path: "fields.properties"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "removeBinaryField",
    component: _shared_imports.ToggleField,
    config: fieldsConfig.remove_binary,
    path: "fields.remove_binary"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "resourceNameField",
    config: fieldsConfig.resource_name,
    component: _shared_imports.Field,
    path: "fields.resource_name"
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, null));
};
exports.Attachment = Attachment;