"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.savedObjectReferenceRT = exports.resolveSavedObjectReferences = exports.extractSavedObjectReferences = exports.SavedObjectReferenceResolutionError = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const savedObjectReferenceRT = exports.savedObjectReferenceRT = rt.strict({
  name: rt.string,
  type: rt.string,
  id: rt.string
});

/**
 * Rewrites a saved object such that well-known saved object references
 * are extracted in the `references` array and replaced by the appropriate
 * name. This is the inverse operation to `resolveSavedObjectReferences`.
 */
const extractSavedObjectReferences = referenceExtractors => savedObjectAttributes => referenceExtractors.reduce(({
  attributes: accumulatedAttributes,
  references: accumulatedReferences
}, extract) => {
  const {
    attributes,
    references
  } = extract(accumulatedAttributes);
  return {
    attributes,
    references: [...accumulatedReferences, ...references]
  };
}, {
  attributes: savedObjectAttributes,
  references: []
});

/**
 * Rewrites a source configuration such that well-known saved object references
 * are resolved from the `references` argument and replaced by the real saved
 * object ids. This is the inverse operation to `extractSavedObjectReferences`.
 */
exports.extractSavedObjectReferences = extractSavedObjectReferences;
const resolveSavedObjectReferences = referenceResolvers => (attributes, references) => referenceResolvers.reduce((accumulatedAttributes, resolve) => resolve(accumulatedAttributes, references), attributes);
exports.resolveSavedObjectReferences = resolveSavedObjectReferences;
class SavedObjectReferenceResolutionError extends Error {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, new.target.prototype);
    this.name = 'SavedObjectReferenceResolutionError';
  }
}
exports.SavedObjectReferenceResolutionError = SavedObjectReferenceResolutionError;