"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stopDatafeedsResponsePayloadRT = exports.stopDatafeedsRequestPayloadRT = exports.getJobDeletionTasksResponsePayloadRT = exports.deleteJobsResponsePayloadRT = exports.deleteJobsRequestPayloadRT = exports.callStopDatafeeds = exports.callGetJobDeletionTasks = exports.callDeleteJobs = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _infra_ml = require("../../../../common/infra_ml");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callDeleteJobs = async (requestArgs, fetch) => {
  const {
    spaceId,
    sourceId,
    jobTypes
  } = requestArgs;

  // NOTE: Deleting the jobs via this API will delete the datafeeds at the same time
  const deleteJobsResponse = await fetch('/internal/ml/jobs/delete_jobs', {
    method: 'POST',
    version: '1',
    body: JSON.stringify(deleteJobsRequestPayloadRT.encode({
      jobIds: jobTypes.map(jobType => (0, _infra_ml.getJobId)(spaceId, sourceId, jobType))
    }))
  });
  return (0, _ioTsUtils.decodeOrThrow)(deleteJobsResponsePayloadRT)(deleteJobsResponse);
};
exports.callDeleteJobs = callDeleteJobs;
const callGetJobDeletionTasks = async fetch => {
  const jobDeletionTasksResponse = await fetch('/internal/ml/jobs/blocking_jobs_tasks', {
    version: '1'
  });
  return (0, _ioTsUtils.decodeOrThrow)(getJobDeletionTasksResponsePayloadRT)(jobDeletionTasksResponse);
};
exports.callGetJobDeletionTasks = callGetJobDeletionTasks;
const callStopDatafeeds = async (requestArgs, fetch) => {
  const {
    spaceId,
    sourceId,
    jobTypes
  } = requestArgs;

  // Stop datafeed due to https://github.com/elastic/kibana/issues/44652
  const stopDatafeedResponse = await fetch('/internal/ml/jobs/stop_datafeeds', {
    method: 'POST',
    version: '1',
    body: JSON.stringify(stopDatafeedsRequestPayloadRT.encode({
      datafeedIds: jobTypes.map(jobType => (0, _infra_ml.getDatafeedId)(spaceId, sourceId, jobType))
    }))
  });
  return (0, _ioTsUtils.decodeOrThrow)(stopDatafeedsResponsePayloadRT)(stopDatafeedResponse);
};
exports.callStopDatafeeds = callStopDatafeeds;
const deleteJobsRequestPayloadRT = exports.deleteJobsRequestPayloadRT = rt.type({
  jobIds: rt.array(rt.string)
});
const deleteJobsResponsePayloadRT = exports.deleteJobsResponsePayloadRT = rt.record(rt.string, rt.type({
  deleted: rt.boolean
}));
const getJobDeletionTasksResponsePayloadRT = exports.getJobDeletionTasksResponsePayloadRT = rt.type({
  jobs: rt.array(rt.record(rt.string, rt.string))
});
const stopDatafeedsRequestPayloadRT = exports.stopDatafeedsRequestPayloadRT = rt.type({
  datafeedIds: rt.array(rt.string)
});
const stopDatafeedsResponsePayloadRT = exports.stopDatafeedsResponsePayloadRT = rt.record(rt.string, rt.type({
  stopped: rt.boolean
}));