"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamActionsMenu = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataStreamActionsMenu = ({
  dataStreamActions,
  selectedDataStreamsCount
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const popoverButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "dataStreamActionsPopoverButton",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    iconType: "arrowDown",
    iconSide: "right",
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreamList.table.manageDataStreamsButtonLabel",
    defaultMessage: "Manage {selectedDataStreamsCount, plural, one {data stream} other {{selectedDataStreamsCount} data streams}}",
    values: {
      selectedDataStreamsCount
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "dataStreamActionsPopover",
    button: popoverButton,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "rightUp",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    "data-test-subj": "dataStreamActionsContextMenu",
    initialPanelId: 0,
    panels: [{
      id: 0,
      title: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.dataStreamsContextMenuPanelLabel', {
        defaultMessage: 'Data stream options'
      }),
      items: dataStreamActions
    }]
  }));
};
exports.DataStreamActionsMenu = DataStreamActionsMenu;