"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractDefaultDynamicKafkaTopics = extractDefaultDynamicKafkaTopics;
exports.extractDefaultStaticKafkaTopic = extractDefaultStaticKafkaTopic;
exports.useOutputForm = useOutputForm;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _jsYaml = require("js-yaml");
var _output_helpers = require("../../../../../../../common/services/output_helpers");
var _constants = require("../../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _use_confirm_modal = require("../../hooks/use_confirm_modal");
var _services = require("../../../../services");
var _output_form_validators = require("./output_form_validators");
var _confirm_update = require("./confirm_update");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_QUEUE_MAX_SIZE = 4096;
function extractKafkaOutputSecrets(inputs) {
  const secrets = {};
  if (!inputs.kafkaSslKeyInput.value && inputs.kafkaSslKeySecretInput.value) {
    secrets.ssl = {
      key: inputs.kafkaSslKeySecretInput.value
    };
  }
  if (!inputs.kafkaAuthPasswordInput.value && inputs.kafkaAuthPasswordSecretInput.value) {
    secrets.password = inputs.kafkaAuthPasswordSecretInput.value;
  }
  return Object.keys(secrets).length ? secrets : null;
}
function extractDefaultStaticKafkaTopic(o) {
  var _o$topic;
  if (o !== null && o !== void 0 && (_o$topic = o.topic) !== null && _o$topic !== void 0 && _o$topic.includes('%{[')) {
    return '';
  }
  return (o === null || o === void 0 ? void 0 : o.topic) || '';
}
function extractDefaultDynamicKafkaTopics(o) {
  var _o$topic2;
  if (!(o !== null && o !== void 0 && o.topic) || o !== null && o !== void 0 && o.topic && !((_o$topic2 = o.topic) !== null && _o$topic2 !== void 0 && _o$topic2.includes('%{['))) {
    return [];
  }
  const matched = o.topic.match(/(%\{\[)(\S*)(\]\})/);
  const parsed = matched !== null && matched !== void 0 && matched.length ? matched[2] : '';
  return [{
    label: parsed,
    value: parsed
  }];
}
function useOutputForm(onSucess, output, defaultOutput) {
  var _fleetStatus$missingO, _output$is_preconfigu, _output$allow_edit, _output$name, _output$type, _output$config_yaml, _output$is_default, _output$is_default_mo, _output$ca_trusted_fi, _output$preset, _output$config_yaml2, _service_token, _secrets$service_toke, _secrets, _sync_integrations, _kibana_api_key, _kibana_url, _sync_uninstalled_int, _configJs$shipper, _output$shipper$disk_, _output$shipper, _output$shipper$disk_2, _output$shipper2, _diskQueueEnabledInpu, _output$shipper$disk_3, _output$shipper3, _diskQueueEnabledInpu2, _output$shipper$disk_4, _output$shipper4, _diskQueueEnabledInpu3, _output$shipper$disk_5, _output$shipper5, _output$shipper$disk_6, _output$shipper6, _ref, _output$shipper7, _diskQueueCompression, _output$shipper8, _output$shipper9, _output$shipper10, _output$hosts, _output$ssl$certifica, _output$ssl, _output$ssl$certifica2, _output$ssl2, _output$ssl$key, _output$ssl3, _secrets2, _secrets2$ssl, _output$proxy_id, _kafkaOutput$version, _output$hosts2, _kafkaOutput$auth_typ, _kafkaOutput$connecti, _kafkaOutput$username, _kafkaOutput$password, _kafkaOutput$secrets, _kafkaOutput$ssl$cert, _kafkaOutput$ssl, _kafkaOutput$ssl2, _kafkaOutput$ssl3, _kafkaOutput$secrets2, _kafkaOutput$secrets3, _kafkaOutput$ssl$veri, _kafkaOutput$ssl4, _kafkaOutput$sasl$mec, _kafkaOutput$sasl, _kafkaOutput$partitio, _kafkaOutput$random, _kafkaOutput$hash, _kafkaOutput$round_ro, _kafkaOutput$topic, _kafkaOutput$headers, _kafkaOutput$client_i, _kafkaOutput$compress, _kafkaOutput$timeout, _kafkaOutput$broker_t, _kafkaOutput$required;
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const authz = (0, _hooks.useAuthz)();
  const {
    showExperimentalShipperOptions
  } = _services.ExperimentalFeaturesService.get();
  const hasEncryptedSavedObjectConfigured = !((_fleetStatus$missingO = fleetStatus.missingOptionalFeatures) !== null && _fleetStatus$missingO !== void 0 && _fleetStatus$missingO.includes('encrypted_saved_object_encryption_key_required'));
  const [isLoading, setIsloading] = (0, _react.useState)(false);
  const {
    notifications,
    cloud
  } = (0, _hooks.useStartServices)();
  const {
    confirm
  } = (0, _use_confirm_modal.useConfirmModal)();

  // preconfigured output do not allow edition
  const isPreconfigured = (_output$is_preconfigu = output === null || output === void 0 ? void 0 : output.is_preconfigured) !== null && _output$is_preconfigu !== void 0 ? _output$is_preconfigu : false;
  const allowEdit = (_output$allow_edit = output === null || output === void 0 ? void 0 : output.allow_edit) !== null && _output$allow_edit !== void 0 ? _output$allow_edit : [];
  function isDisabled(field) {
    if (!authz.fleet.allSettings) {
      return true;
    }
    if (!isPreconfigured) {
      return false;
    }
    return !allowEdit.includes(field);
  }

  // Define inputs
  // Shared inputs
  const nameInput = (0, _hooks.useInput)((_output$name = output === null || output === void 0 ? void 0 : output.name) !== null && _output$name !== void 0 ? _output$name : '', _output_form_validators.validateName, isDisabled('name'));
  const typeInput = (0, _hooks.useInput)((_output$type = output === null || output === void 0 ? void 0 : output.type) !== null && _output$type !== void 0 ? _output$type : 'elasticsearch', undefined, isDisabled('type'));
  const additionalYamlConfigInput = (0, _hooks.useInput)((_output$config_yaml = output === null || output === void 0 ? void 0 : output.config_yaml) !== null && _output$config_yaml !== void 0 ? _output$config_yaml : '', _output_form_validators.validateYamlConfig, isDisabled('config_yaml'));
  const defaultOutputInput = (0, _hooks.useSwitchInput)((_output$is_default = output === null || output === void 0 ? void 0 : output.is_default) !== null && _output$is_default !== void 0 ? _output$is_default : false, isDisabled('is_default') || (output === null || output === void 0 ? void 0 : output.is_default));
  const defaultMonitoringOutputInput = (0, _hooks.useSwitchInput)((_output$is_default_mo = output === null || output === void 0 ? void 0 : output.is_default_monitoring) !== null && _output$is_default_mo !== void 0 ? _output$is_default_mo : false, isDisabled('is_default_monitoring') || (output === null || output === void 0 ? void 0 : output.is_default_monitoring));

  // ES inputs
  const caTrustedFingerprintInput = (0, _hooks.useInput)((_output$ca_trusted_fi = output === null || output === void 0 ? void 0 : output.ca_trusted_fingerprint) !== null && _output$ca_trusted_fi !== void 0 ? _output$ca_trusted_fi : '', _output_form_validators.validateCATrustedFingerPrint, isDisabled('ca_trusted_fingerprint'));
  // ES output's host URL is restricted to default in serverless
  const isServerless = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled;
  // Set the hosts to default for new ES output in serverless.
  const elasticsearchUrlDefaultValue = isServerless && !(output !== null && output !== void 0 && output.hosts) ? (defaultOutput === null || defaultOutput === void 0 ? void 0 : defaultOutput.hosts) || [] : (output === null || output === void 0 ? void 0 : output.hosts) || [];
  const elasticsearchUrlDisabled = isServerless || isDisabled('hosts');
  const elasticsearchUrlInput = (0, _hooks.useComboInput)('esHostsComboxBox', elasticsearchUrlDefaultValue, _output_form_validators.validateESHosts, elasticsearchUrlDisabled);
  const presetInput = (0, _hooks.useInput)((_output$preset = output === null || output === void 0 ? void 0 : output.preset) !== null && _output$preset !== void 0 ? _output$preset : (0, _output_helpers.getDefaultPresetForEsOutput)((_output$config_yaml2 = output === null || output === void 0 ? void 0 : output.config_yaml) !== null && _output$config_yaml2 !== void 0 ? _output$config_yaml2 : '', _jsYaml.load), () => undefined, isDisabled('preset'));

  // Remote ES inputs
  const serviceTokenInput = (0, _hooks.useInput)((_service_token = output === null || output === void 0 ? void 0 : output.service_token) !== null && _service_token !== void 0 ? _service_token : '', _output_form_validators.validateServiceToken, isDisabled('service_token'));
  const serviceTokenSecretInput = (0, _hooks.useSecretInput)((_secrets$service_toke = output === null || output === void 0 ? void 0 : (_secrets = output.secrets) === null || _secrets === void 0 ? void 0 : _secrets.service_token) !== null && _secrets$service_toke !== void 0 ? _secrets$service_toke : '', _output_form_validators.validateServiceTokenSecret, isDisabled('service_token'));
  const syncIntegrationsInput = (0, _hooks.useSwitchInput)((_sync_integrations = output === null || output === void 0 ? void 0 : output.sync_integrations) !== null && _sync_integrations !== void 0 ? _sync_integrations : false, isDisabled('sync_integrations'));
  const kibanaAPIKeyInput = (0, _hooks.useInput)((_kibana_api_key = output === null || output === void 0 ? void 0 : output.kibana_api_key) !== null && _kibana_api_key !== void 0 ? _kibana_api_key : '', syncIntegrationsInput.value ? _output_form_validators.validateKibanaAPIKey : undefined, isDisabled('kibana_api_key'));
  const kibanaURLInput = (0, _hooks.useInput)((_kibana_url = output === null || output === void 0 ? void 0 : output.kibana_url) !== null && _kibana_url !== void 0 ? _kibana_url : '', val => (0, _output_form_validators.validateKibanaURL)(val, syncIntegrationsInput.value), isDisabled('kibana_url'));
  const syncUninstalledIntegrationsInput = (0, _hooks.useSwitchInput)((_sync_uninstalled_int = output === null || output === void 0 ? void 0 : output.sync_uninstalled_integrations) !== null && _sync_uninstalled_int !== void 0 ? _sync_uninstalled_int : false, isDisabled('sync_uninstalled_integrations'));
  /*
  Shipper feature flag - currently depends on the content of the yaml
  # Enables the shipper:
  shipper: {}
   # Also enables the shipper:
  shipper:
    enabled: true
   # Yet another way of enabling it:
  shipper:
    queue:
      ...
   # Disables the shipper
  shipper:
    enabled: false
  */
  const configJs = output !== null && output !== void 0 && output.config_yaml ? (0, _jsYaml.load)(output === null || output === void 0 ? void 0 : output.config_yaml) : {};
  const isShipperDisabled = !(configJs !== null && configJs !== void 0 && configJs.shipper) || (configJs === null || configJs === void 0 ? void 0 : (_configJs$shipper = configJs.shipper) === null || _configJs$shipper === void 0 ? void 0 : _configJs$shipper.enabled) === false;
  const diskQueueEnabledInput = (0, _hooks.useSwitchInput)((_output$shipper$disk_ = output === null || output === void 0 ? void 0 : (_output$shipper = output.shipper) === null || _output$shipper === void 0 ? void 0 : _output$shipper.disk_queue_enabled) !== null && _output$shipper$disk_ !== void 0 ? _output$shipper$disk_ : false);
  const diskQueuePathInput = (0, _hooks.useInput)((_output$shipper$disk_2 = output === null || output === void 0 ? void 0 : (_output$shipper2 = output.shipper) === null || _output$shipper2 === void 0 ? void 0 : _output$shipper2.disk_queue_path) !== null && _output$shipper$disk_2 !== void 0 ? _output$shipper$disk_2 : '', undefined, // @ts-expect-error upgrade typescript v5.9.3
  (_diskQueueEnabledInpu = !diskQueueEnabledInput.value) !== null && _diskQueueEnabledInpu !== void 0 ? _diskQueueEnabledInpu : false);
  const diskQueueMaxSizeInput = (0, _hooks.useNumberInput)((_output$shipper$disk_3 = output === null || output === void 0 ? void 0 : (_output$shipper3 = output.shipper) === null || _output$shipper3 === void 0 ? void 0 : _output$shipper3.disk_queue_max_size) !== null && _output$shipper$disk_3 !== void 0 ? _output$shipper$disk_3 : DEFAULT_QUEUE_MAX_SIZE, undefined, // @ts-expect-error upgrade typescript v5.9.3
  (_diskQueueEnabledInpu2 = !diskQueueEnabledInput.value) !== null && _diskQueueEnabledInpu2 !== void 0 ? _diskQueueEnabledInpu2 : false);
  const diskQueueEncryptionEnabled = (0, _hooks.useSwitchInput)((_output$shipper$disk_4 = output === null || output === void 0 ? void 0 : (_output$shipper4 = output.shipper) === null || _output$shipper4 === void 0 ? void 0 : _output$shipper4.disk_queue_encryption_enabled) !== null && _output$shipper$disk_4 !== void 0 ? _output$shipper$disk_4 : false, // @ts-expect-error upgrade typescript v5.9.3
  (_diskQueueEnabledInpu3 = !diskQueueEnabledInput.value) !== null && _diskQueueEnabledInpu3 !== void 0 ? _diskQueueEnabledInpu3 : false);
  const loadBalanceEnabledInput = (0, _hooks.useSwitchInput)((_output$shipper$disk_5 = output === null || output === void 0 ? void 0 : (_output$shipper5 = output.shipper) === null || _output$shipper5 === void 0 ? void 0 : _output$shipper5.disk_queue_enabled) !== null && _output$shipper$disk_5 !== void 0 ? _output$shipper$disk_5 : false);
  const diskQueueCompressionEnabled = (0, _hooks.useSwitchInput)((_output$shipper$disk_6 = output === null || output === void 0 ? void 0 : (_output$shipper6 = output.shipper) === null || _output$shipper6 === void 0 ? void 0 : _output$shipper6.disk_queue_compression_enabled) !== null && _output$shipper$disk_6 !== void 0 ? _output$shipper$disk_6 : false);
  const options = Array.from(Array(10).keys()).slice(1).map(val => {
    return {
      value: `${val}`,
      text: `Level ${val}`
    };
  });
  const compressionLevelInput = (0, _hooks.useSelectInput)(options, // @ts-expect-error upgrade typescript v5.9.3
  (_ref = `${output === null || output === void 0 ? void 0 : (_output$shipper7 = output.shipper) === null || _output$shipper7 === void 0 ? void 0 : _output$shipper7.compression_level}`) !== null && _ref !== void 0 ? _ref : options[0].value, // @ts-expect-error upgrade typescript v5.9.3
  (_diskQueueCompression = !diskQueueCompressionEnabled.value) !== null && _diskQueueCompression !== void 0 ? _diskQueueCompression : false);
  const memQueueEvents = (0, _hooks.useNumberInput)((output === null || output === void 0 ? void 0 : (_output$shipper8 = output.shipper) === null || _output$shipper8 === void 0 ? void 0 : _output$shipper8.mem_queue_events) || undefined);
  const queueFlushTimeout = (0, _hooks.useNumberInput)((output === null || output === void 0 ? void 0 : (_output$shipper9 = output.shipper) === null || _output$shipper9 === void 0 ? void 0 : _output$shipper9.queue_flush_timeout) || undefined);
  const maxBatchBytes = (0, _hooks.useNumberInput)((output === null || output === void 0 ? void 0 : (_output$shipper10 = output.shipper) === null || _output$shipper10 === void 0 ? void 0 : _output$shipper10.max_batch_bytes) || undefined);
  const isSSLEditable = isDisabled('ssl');
  // Logstash inputs
  const logstashEnableSSLInput = (0, _hooks.useSwitchInput)((output === null || output === void 0 ? void 0 : output.type) === 'logstash' ? Boolean(output === null || output === void 0 ? void 0 : output.ssl) : true, isSSLEditable);
  const logstashHostsInput = (0, _hooks.useComboInput)('logstashHostsComboxBox', (_output$hosts = output === null || output === void 0 ? void 0 : output.hosts) !== null && _output$hosts !== void 0 ? _output$hosts : [], _output_form_validators.validateLogstashHosts, isDisabled('hosts'));
  const sslCertificateAuthoritiesInput = (0, _hooks.useComboInput)('sslCertificateAuthoritiesComboxBox', (_output$ssl$certifica = output === null || output === void 0 ? void 0 : (_output$ssl = output.ssl) === null || _output$ssl === void 0 ? void 0 : _output$ssl.certificate_authorities) !== null && _output$ssl$certifica !== void 0 ? _output$ssl$certifica : [], undefined, isSSLEditable);
  const sslCertificateInput = (0, _hooks.useInput)((_output$ssl$certifica2 = output === null || output === void 0 ? void 0 : (_output$ssl2 = output.ssl) === null || _output$ssl2 === void 0 ? void 0 : _output$ssl2.certificate) !== null && _output$ssl$certifica2 !== void 0 ? _output$ssl$certifica2 : '', (output === null || output === void 0 ? void 0 : output.type) === 'logstash' && logstashEnableSSLInput.value ? _output_form_validators.validateSSLCertificate : undefined, isSSLEditable);
  const sslKeyInput = (0, _hooks.useInput)((_output$ssl$key = output === null || output === void 0 ? void 0 : (_output$ssl3 = output.ssl) === null || _output$ssl3 === void 0 ? void 0 : _output$ssl3.key) !== null && _output$ssl$key !== void 0 ? _output$ssl$key : '', (output === null || output === void 0 ? void 0 : output.type) === 'logstash' && logstashEnableSSLInput.value ? _output_form_validators.validateSSLKey : undefined, isSSLEditable);
  const sslKeySecretInput = (0, _hooks.useSecretInput)(output === null || output === void 0 ? void 0 : (_secrets2 = output.secrets) === null || _secrets2 === void 0 ? void 0 : (_secrets2$ssl = _secrets2.ssl) === null || _secrets2$ssl === void 0 ? void 0 : _secrets2$ssl.key, (output === null || output === void 0 ? void 0 : output.type) === 'logstash' && logstashEnableSSLInput.value ? _output_form_validators.validateSSLKeySecret : undefined, isSSLEditable);
  const proxyIdInput = (0, _hooks.useInput)((_output$proxy_id = output === null || output === void 0 ? void 0 : output.proxy_id) !== null && _output$proxy_id !== void 0 ? _output$proxy_id : '', () => undefined, isDisabled('proxy_id'));

  /**
   * Kafka inputs
   */

  const kafkaOutput = output;
  const kafkaVersionInput = (0, _hooks.useInput)((_kafkaOutput$version = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.version) !== null && _kafkaOutput$version !== void 0 ? _kafkaOutput$version : '1.0.0', undefined, isDisabled('version'));
  const kafkaHostsInput = (0, _hooks.useComboInput)('kafkaHostsComboBox', (_output$hosts2 = output === null || output === void 0 ? void 0 : output.hosts) !== null && _output$hosts2 !== void 0 ? _output$hosts2 : [], _output_form_validators.validateKafkaHosts, isDisabled('hosts'));
  const kafkaAuthMethodInput = (0, _hooks.useRadioInput)((_kafkaOutput$auth_typ = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.auth_type) !== null && _kafkaOutput$auth_typ !== void 0 ? _kafkaOutput$auth_typ : _constants.kafkaAuthType.None, isDisabled('auth_type'));
  const kafkaConnectionTypeInput = (0, _hooks.useRadioInput)((_kafkaOutput$connecti = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.connection_type) !== null && _kafkaOutput$connecti !== void 0 ? _kafkaOutput$connecti : _constants.kafkaConnectionType.Plaintext, isDisabled('connection_type'));
  const kafkaAuthUsernameInput = (0, _hooks.useInput)((_kafkaOutput$username = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.username) !== null && _kafkaOutput$username !== void 0 ? _kafkaOutput$username : undefined, kafkaAuthMethodInput.value === _constants.kafkaAuthType.Userpass ? _output_form_validators.validateKafkaUsername : undefined, isDisabled('username'));
  const kafkaAuthPasswordInput = (0, _hooks.useInput)((_kafkaOutput$password = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.password) !== null && _kafkaOutput$password !== void 0 ? _kafkaOutput$password : undefined, kafkaAuthMethodInput.value === _constants.kafkaAuthType.Userpass ? _output_form_validators.validateKafkaPassword : undefined, isDisabled('password'));
  const kafkaAuthPasswordSecretInput = (0, _hooks.useSecretInput)(kafkaOutput === null || kafkaOutput === void 0 ? void 0 : (_kafkaOutput$secrets = kafkaOutput.secrets) === null || _kafkaOutput$secrets === void 0 ? void 0 : _kafkaOutput$secrets.password, kafkaAuthMethodInput.value === _constants.kafkaAuthType.Userpass ? _output_form_validators.validateKafkaPasswordSecret : undefined, isDisabled('password'));
  const kafkaSslCertificateAuthoritiesInput = (0, _hooks.useComboInput)('kafkaSslCertificateAuthoritiesComboBox', (_kafkaOutput$ssl$cert = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : (_kafkaOutput$ssl = kafkaOutput.ssl) === null || _kafkaOutput$ssl === void 0 ? void 0 : _kafkaOutput$ssl.certificate_authorities) !== null && _kafkaOutput$ssl$cert !== void 0 ? _kafkaOutput$ssl$cert : [], undefined, isSSLEditable);
  const kafkaSslCertificateInput = (0, _hooks.useInput)(kafkaOutput === null || kafkaOutput === void 0 ? void 0 : (_kafkaOutput$ssl2 = kafkaOutput.ssl) === null || _kafkaOutput$ssl2 === void 0 ? void 0 : _kafkaOutput$ssl2.certificate, kafkaAuthMethodInput.value === _constants.kafkaAuthType.Ssl ? _output_form_validators.validateSSLCertificate : undefined, isSSLEditable);
  const kafkaSslKeyInput = (0, _hooks.useInput)(kafkaOutput === null || kafkaOutput === void 0 ? void 0 : (_kafkaOutput$ssl3 = kafkaOutput.ssl) === null || _kafkaOutput$ssl3 === void 0 ? void 0 : _kafkaOutput$ssl3.key, kafkaAuthMethodInput.value === _constants.kafkaAuthType.Ssl ? _output_form_validators.validateSSLKey : undefined, isSSLEditable);
  const kafkaSslKeySecretInput = (0, _hooks.useSecretInput)(kafkaOutput === null || kafkaOutput === void 0 ? void 0 : (_kafkaOutput$secrets2 = kafkaOutput.secrets) === null || _kafkaOutput$secrets2 === void 0 ? void 0 : (_kafkaOutput$secrets3 = _kafkaOutput$secrets2.ssl) === null || _kafkaOutput$secrets3 === void 0 ? void 0 : _kafkaOutput$secrets3.key, kafkaAuthMethodInput.value === _constants.kafkaAuthType.Ssl ? _output_form_validators.validateSSLKeySecret : undefined, isSSLEditable);
  const kafkaVerificationModeInput = (0, _hooks.useInput)((_kafkaOutput$ssl$veri = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : (_kafkaOutput$ssl4 = kafkaOutput.ssl) === null || _kafkaOutput$ssl4 === void 0 ? void 0 : _kafkaOutput$ssl4.verification_mode) !== null && _kafkaOutput$ssl$veri !== void 0 ? _kafkaOutput$ssl$veri : _constants.kafkaVerificationModes.Full, undefined, isSSLEditable);
  const kafkaSaslMechanismInput = (0, _hooks.useRadioInput)((_kafkaOutput$sasl$mec = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : (_kafkaOutput$sasl = kafkaOutput.sasl) === null || _kafkaOutput$sasl === void 0 ? void 0 : _kafkaOutput$sasl.mechanism) !== null && _kafkaOutput$sasl$mec !== void 0 ? _kafkaOutput$sasl$mec : _constants.kafkaSaslMechanism.Plain, isDisabled('sasl'));
  const kafkaPartitionTypeInput = (0, _hooks.useRadioInput)((_kafkaOutput$partitio = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.partition) !== null && _kafkaOutput$partitio !== void 0 ? _kafkaOutput$partitio : _constants.kafkaPartitionType.Random, isDisabled('partition'));
  const kafkaPartitionTypeRandomInput = (0, _hooks.useInput)(kafkaOutput !== null && kafkaOutput !== void 0 && (_kafkaOutput$random = kafkaOutput.random) !== null && _kafkaOutput$random !== void 0 && _kafkaOutput$random.group_events ? `${kafkaOutput.random.group_events}` : '1', kafkaPartitionTypeInput.value === _constants.kafkaPartitionType.Random ? _output_form_validators.validateKafkaPartitioningGroupEvents : undefined, isDisabled('partition'));
  const kafkaPartitionTypeHashInput = (0, _hooks.useInput)(kafkaOutput === null || kafkaOutput === void 0 ? void 0 : (_kafkaOutput$hash = kafkaOutput.hash) === null || _kafkaOutput$hash === void 0 ? void 0 : _kafkaOutput$hash.hash, undefined, isDisabled('partition'));
  const kafkaPartitionTypeRoundRobinInput = (0, _hooks.useInput)(kafkaOutput !== null && kafkaOutput !== void 0 && (_kafkaOutput$round_ro = kafkaOutput.round_robin) !== null && _kafkaOutput$round_ro !== void 0 && _kafkaOutput$round_ro.group_events ? `${kafkaOutput.round_robin.group_events}` : '1', kafkaPartitionTypeInput.value === _constants.kafkaPartitionType.RoundRobin ? _output_form_validators.validateKafkaPartitioningGroupEvents : undefined, isDisabled('partition'));
  const kafkaTopicsInput = (0, _hooks.useRadioInput)(kafkaOutput !== null && kafkaOutput !== void 0 && kafkaOutput.topic && kafkaOutput !== null && kafkaOutput !== void 0 && (_kafkaOutput$topic = kafkaOutput.topic) !== null && _kafkaOutput$topic !== void 0 && _kafkaOutput$topic.includes('%{[') ? _constants.kafkaTopicsType.Dynamic : _constants.kafkaTopicsType.Static, isDisabled('topic'));
  const kafkaStaticTopicInput = (0, _hooks.useInput)(extractDefaultStaticKafkaTopic(kafkaOutput), kafkaTopicsInput.value === _constants.kafkaTopicsType.Static ? _output_form_validators.validateKafkaStaticTopic : undefined, isDisabled('topic'));
  const kafkaDynamicTopicInput = (0, _hooks.useComboBoxWithCustomInput)('kafkaDynamicTopicComboBox', extractDefaultDynamicKafkaTopics(kafkaOutput), kafkaTopicsInput.value === _constants.kafkaTopicsType.Dynamic ? _output_form_validators.validateDynamicKafkaTopics : undefined, isDisabled('topic'));
  const kafkaHeadersInput = (0, _hooks.useKeyValueInput)('kafkaHeadersComboBox', (_kafkaOutput$headers = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.headers) !== null && _kafkaOutput$headers !== void 0 ? _kafkaOutput$headers : [{
    key: '',
    value: ''
  }], _output_form_validators.validateKafkaHeaders, isDisabled('headers'));
  const kafkaClientIdInput = (0, _hooks.useInput)((_kafkaOutput$client_i = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.client_id) !== null && _kafkaOutput$client_i !== void 0 ? _kafkaOutput$client_i : 'Elastic', _output_form_validators.validateKafkaClientId, isDisabled('client_id'));
  const kafkaCompressionInput = (0, _hooks.useSwitchInput)(!!(kafkaOutput !== null && kafkaOutput !== void 0 && kafkaOutput.compression && kafkaOutput.compression !== _constants.kafkaCompressionType.None), isDisabled('compression'));
  const kafkaCompressionLevelInput = (0, _hooks.useInput)(`${(_kafkaOutput$compress = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.compression_level) !== null && _kafkaOutput$compress !== void 0 ? _kafkaOutput$compress : 4}`, undefined, isDisabled('compression_level'));
  const kafkaCompressionCodecInput = (0, _hooks.useInput)(kafkaOutput !== null && kafkaOutput !== void 0 && kafkaOutput.compression && kafkaOutput.compression !== _constants.kafkaCompressionType.None ? kafkaOutput.compression : _constants.kafkaCompressionType.Gzip, undefined, isDisabled('compression'));
  const kafkaBrokerTimeoutInput = (0, _hooks.useInput)(`${(_kafkaOutput$timeout = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.timeout) !== null && _kafkaOutput$timeout !== void 0 ? _kafkaOutput$timeout : 30}`, undefined, isDisabled('broker_timeout'));
  const kafkaBrokerReachabilityTimeoutInput = (0, _hooks.useInput)(`${(_kafkaOutput$broker_t = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.broker_timeout) !== null && _kafkaOutput$broker_t !== void 0 ? _kafkaOutput$broker_t : 30}`, undefined, isDisabled('timeout'));
  const kafkaBrokerAckReliabilityInput = (0, _hooks.useInput)(`${(_kafkaOutput$required = kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.required_acks) !== null && _kafkaOutput$required !== void 0 ? _kafkaOutput$required : _constants.kafkaAcknowledgeReliabilityLevel.Commit}`, undefined, isDisabled('required_acks'));
  const kafkaKeyInput = (0, _hooks.useInput)(kafkaOutput === null || kafkaOutput === void 0 ? void 0 : kafkaOutput.key, undefined, isDisabled('key'));
  const isLogstash = typeInput.value === _constants.outputType.Logstash;
  const isKafka = typeInput.value === _constants.outputType.Kafka;
  const isRemoteElasticsearch = typeInput.value === _constants.outputType.RemoteElasticsearch;
  const inputs = {
    nameInput,
    typeInput,
    elasticsearchUrlInput,
    diskQueueEnabledInput,
    diskQueuePathInput,
    diskQueueEncryptionEnabled,
    diskQueueMaxSizeInput,
    diskQueueCompressionEnabled,
    compressionLevelInput,
    logstashEnableSSLInput,
    logstashHostsInput,
    presetInput,
    additionalYamlConfigInput,
    defaultOutputInput,
    defaultMonitoringOutputInput,
    caTrustedFingerprintInput,
    serviceTokenInput,
    serviceTokenSecretInput,
    kibanaAPIKeyInput,
    syncIntegrationsInput,
    kibanaURLInput,
    syncUninstalledIntegrationsInput,
    sslCertificateInput,
    sslKeyInput,
    sslKeySecretInput,
    sslCertificateAuthoritiesInput,
    proxyIdInput,
    loadBalanceEnabledInput,
    memQueueEvents,
    queueFlushTimeout,
    maxBatchBytes,
    kafkaVersionInput,
    kafkaHostsInput,
    kafkaVerificationModeInput,
    kafkaAuthMethodInput,
    kafkaConnectionTypeInput,
    kafkaAuthUsernameInput,
    kafkaAuthPasswordInput,
    kafkaAuthPasswordSecretInput,
    kafkaSaslMechanismInput,
    kafkaPartitionTypeInput,
    kafkaPartitionTypeRandomInput,
    kafkaPartitionTypeHashInput,
    kafkaPartitionTypeRoundRobinInput,
    kafkaHeadersInput,
    kafkaClientIdInput,
    kafkaCompressionInput,
    kafkaCompressionLevelInput,
    kafkaCompressionCodecInput,
    kafkaBrokerTimeoutInput,
    kafkaBrokerReachabilityTimeoutInput,
    kafkaBrokerAckReliabilityInput,
    kafkaKeyInput,
    kafkaSslCertificateAuthoritiesInput,
    kafkaSslCertificateInput,
    kafkaSslKeyInput,
    kafkaSslKeySecretInput,
    kafkaTopicsInput,
    kafkaStaticTopicInput,
    kafkaDynamicTopicInput
  };
  const hasChanged = Object.values(inputs).some(input => input.hasChanged);
  const validate = (0, _react.useCallback)(() => {
    const nameInputValid = nameInput.validate();
    const elasticsearchUrlsValid = elasticsearchUrlInput.validate();
    const kafkaHostsValid = kafkaHostsInput.validate();
    const kafkaUsernameValid = kafkaAuthUsernameInput.validate();
    const kafkaPasswordPlainValid = kafkaAuthPasswordInput.validate();
    const kafkaPasswordSecretValid = kafkaAuthPasswordSecretInput.validate();
    const kafkaClientIDValid = kafkaClientIdInput.validate();
    const kafkaSslCertificateValid = kafkaSslCertificateInput.validate();
    const kafkaSslKeyPlainValid = kafkaSslKeyInput.validate();
    const kafkaSslKeySecretValid = kafkaSslKeySecretInput.validate();
    const kafkaHeadersValid = kafkaHeadersInput.validate();
    const logstashHostsValid = logstashHostsInput.validate();
    const additionalYamlConfigValid = additionalYamlConfigInput.validate();
    const caTrustedFingerprintValid = caTrustedFingerprintInput.validate();
    const serviceTokenValid = serviceTokenInput.validate();
    const serviceTokenSecretValid = serviceTokenSecretInput.validate();
    const kibanaAPIKeyValid = kibanaAPIKeyInput.validate();
    const kibanaURLInputValid = kibanaURLInput.validate();
    const sslCertificateValid = sslCertificateInput.validate();
    const sslKeyValid = sslKeyInput.validate();
    const sslKeySecretValid = sslKeySecretInput.validate();
    const diskQueuePathValid = diskQueuePathInput.validate();
    const partitioningRandomGroupEventsValid = kafkaPartitionTypeRandomInput.validate();
    const partitioningRoundRobinGroupEventsValid = kafkaPartitionTypeRoundRobinInput.validate();
    const kafkaStaticTopicInputValid = kafkaStaticTopicInput.validate();
    const kafkaStaticDynamicTopicInputValid = kafkaDynamicTopicInput.validate();
    const kafkaSslKeyValid = kafkaSslKeyInput.value ? kafkaSslKeyPlainValid : kafkaSslKeySecretValid;
    const kafkaPasswordValid = kafkaAuthPasswordInput.value ? kafkaPasswordPlainValid : kafkaPasswordSecretValid;
    if (isLogstash) {
      // validate logstash
      return logstashHostsValid && additionalYamlConfigValid && nameInputValid && sslCertificateValid && (sslKeyValid || sslKeySecretValid);
    }
    if (isKafka) {
      // validate kafka
      return nameInputValid && kafkaHostsValid && kafkaSslCertificateValid && kafkaSslKeyValid && kafkaUsernameValid && kafkaPasswordValid && kafkaHeadersValid && additionalYamlConfigValid && kafkaClientIDValid && partitioningRandomGroupEventsValid && partitioningRoundRobinGroupEventsValid && kafkaStaticTopicInputValid && kafkaStaticDynamicTopicInputValid;
    }
    if (isRemoteElasticsearch) {
      return elasticsearchUrlsValid && additionalYamlConfigValid && nameInputValid && (serviceTokenInput.value && serviceTokenValid || serviceTokenSecretInput.value && serviceTokenSecretValid) && (!syncIntegrationsInput.value && kibanaURLInputValid || syncIntegrationsInput.value && kibanaAPIKeyInput.value && kibanaAPIKeyValid && kibanaURLInputValid);
    } else {
      // validate ES
      return elasticsearchUrlsValid && additionalYamlConfigValid && nameInputValid && caTrustedFingerprintValid && diskQueuePathValid;
    }
  }, [nameInput, elasticsearchUrlInput, kafkaHostsInput, kafkaAuthUsernameInput, kafkaAuthPasswordInput, kafkaAuthPasswordSecretInput, kafkaClientIdInput, kafkaSslCertificateInput, kafkaSslKeyInput, kafkaSslKeySecretInput, kafkaHeadersInput, logstashHostsInput, additionalYamlConfigInput, caTrustedFingerprintInput, serviceTokenInput, serviceTokenSecretInput, kibanaAPIKeyInput, syncIntegrationsInput, kibanaURLInput, sslCertificateInput, sslKeyInput, sslKeySecretInput, diskQueuePathInput, kafkaPartitionTypeRandomInput, kafkaPartitionTypeRoundRobinInput, kafkaStaticTopicInput, kafkaDynamicTopicInput, isLogstash, isKafka, isRemoteElasticsearch]);
  const submit = (0, _react.useCallback)(async () => {
    try {
      if (!validate()) {
        return;
      }
      setIsloading(true);
      let shipperParams = {};
      if (!isShipperDisabled) {
        shipperParams = {
          shipper: {
            mem_queue_events: memQueueEvents.value ? Number(memQueueEvents.value) : null,
            queue_flush_timeout: queueFlushTimeout.value ? Number(queueFlushTimeout.value) : null,
            max_batch_bytes: maxBatchBytes.value ? Number(maxBatchBytes.value) : null
          }
        };
      }
      if (!isShipperDisabled && showExperimentalShipperOptions) {
        shipperParams = {
          ...shipperParams,
          shipper: {
            disk_queue_enabled: diskQueueEnabledInput.value,
            disk_queue_path: diskQueueEnabledInput.value && diskQueuePathInput.value ? diskQueuePathInput.value : '',
            disk_queue_max_size: diskQueueEnabledInput.value && diskQueueMaxSizeInput.value ? diskQueueMaxSizeInput.value : null,
            disk_queue_encryption_enabled: diskQueueEnabledInput.value && diskQueueEncryptionEnabled.value,
            disk_queue_compression_enabled: diskQueueCompressionEnabled.value,
            compression_level: diskQueueCompressionEnabled.value ? Number(compressionLevelInput.value) : null,
            loadbalance: loadBalanceEnabledInput.value
          }
        };
      }
      const proxyIdValue = proxyIdInput.value !== '' ? proxyIdInput.value : null;
      const payload = (() => {
        const parseIntegerIfStringDefined = value => {
          if (value !== undefined) {
            const parsedInt = parseInt(value, 10);
            if (!isNaN(parsedInt)) {
              return parsedInt;
            }
          }
          return undefined;
        };
        switch (typeInput.value) {
          case _constants.outputType.Kafka:
            const definedCA = kafkaSslCertificateAuthoritiesInput.value.filter(val => val !== '').length;
            const maybeSecrets = extractKafkaOutputSecrets({
              kafkaSslKeyInput,
              kafkaSslKeySecretInput,
              kafkaAuthPasswordInput,
              kafkaAuthPasswordSecretInput
            });
            return {
              name: nameInput.value,
              type: _constants.outputType.Kafka,
              hosts: kafkaHostsInput.value,
              is_default: defaultOutputInput.value,
              is_default_monitoring: defaultMonitoringOutputInput.value,
              config_yaml: additionalYamlConfigInput.value,
              ...(kafkaConnectionTypeInput.value !== _constants.kafkaConnectionType.Plaintext || kafkaAuthMethodInput.value !== _constants.kafkaAuthType.None ? {
                ssl: {
                  ...(definedCA ? {
                    certificate_authorities: kafkaSslCertificateAuthoritiesInput.value.filter(val => val !== '')
                  } : {}),
                  ...(kafkaAuthMethodInput.value === _constants.kafkaAuthType.Ssl ? {
                    certificate: kafkaSslCertificateInput.value,
                    key: kafkaSslKeyInput.value
                  } : {}),
                  verification_mode: kafkaVerificationModeInput.value
                }
              } : {}),
              proxy_id: proxyIdValue,
              client_id: kafkaClientIdInput.value || undefined,
              version: kafkaVersionInput.value,
              ...(kafkaKeyInput.value ? {
                key: kafkaKeyInput.value
              } : {}),
              compression: kafkaCompressionInput.value ? kafkaCompressionCodecInput.value : _constants.kafkaCompressionType.None,
              ...(kafkaCompressionInput.value && kafkaCompressionCodecInput.value === _constants.kafkaCompressionType.Gzip ? {
                compression_level: parseIntegerIfStringDefined(kafkaCompressionLevelInput.value)
              } : {}),
              auth_type: kafkaAuthMethodInput.value,
              ...(kafkaAuthMethodInput.value === _constants.kafkaAuthType.None ? {
                connection_type: kafkaConnectionTypeInput.value
              } : {}),
              ...(kafkaAuthMethodInput.value === _constants.kafkaAuthType.Userpass && kafkaAuthUsernameInput.value ? {
                username: kafkaAuthUsernameInput.value
              } : {}),
              ...(kafkaAuthMethodInput.value === _constants.kafkaAuthType.Userpass && kafkaAuthPasswordInput.value ? {
                password: kafkaAuthPasswordInput.value
              } : {}),
              ...(kafkaAuthMethodInput.value === _constants.kafkaAuthType.Userpass && kafkaSaslMechanismInput.value ? {
                sasl: {
                  mechanism: kafkaSaslMechanismInput.value
                }
              } : {}),
              partition: kafkaPartitionTypeInput.value,
              ...(kafkaPartitionTypeInput.value === _constants.kafkaPartitionType.Random && kafkaPartitionTypeRandomInput.value ? {
                random: {
                  group_events: parseIntegerIfStringDefined(kafkaPartitionTypeRandomInput.value)
                }
              } : {}),
              ...(kafkaPartitionTypeInput.value === _constants.kafkaPartitionType.RoundRobin && kafkaPartitionTypeRoundRobinInput.value ? {
                round_robin: {
                  group_events: parseIntegerIfStringDefined(kafkaPartitionTypeRoundRobinInput.value)
                }
              } : {}),
              ...(kafkaPartitionTypeInput.value === _constants.kafkaPartitionType.Hash && kafkaPartitionTypeHashInput.value ? {
                hash: {
                  hash: kafkaPartitionTypeHashInput.value
                }
              } : {}),
              ...(kafkaTopicsInput.value === _constants.kafkaTopicsType.Static && kafkaStaticTopicInput.value ? {
                topic: kafkaStaticTopicInput.value
              } : kafkaTopicsInput.value === _constants.kafkaTopicsType.Dynamic && kafkaDynamicTopicInput.value ? {
                topic: `%{[${kafkaDynamicTopicInput.value}]}`
              } : {}),
              headers: kafkaHeadersInput.value,
              timeout: parseIntegerIfStringDefined(kafkaBrokerTimeoutInput.value),
              broker_timeout: parseIntegerIfStringDefined(kafkaBrokerReachabilityTimeoutInput.value),
              required_acks: parseIntegerIfStringDefined(kafkaBrokerAckReliabilityInput.value),
              ...shipperParams,
              ...(maybeSecrets ? {
                secrets: maybeSecrets
              } : {})
            };
          case _constants.outputType.Logstash:
            return {
              name: nameInput.value,
              type: _constants.outputType.Logstash,
              hosts: logstashHostsInput.value,
              is_default: defaultOutputInput.value,
              is_default_monitoring: defaultMonitoringOutputInput.value,
              config_yaml: additionalYamlConfigInput.value,
              ssl: logstashEnableSSLInput.value ? {
                certificate: sslCertificateInput.value,
                key: sslKeyInput.value || undefined,
                certificate_authorities: sslCertificateAuthoritiesInput.value.filter(val => val !== '')
              } : null,
              ...(!sslKeyInput.value && sslKeySecretInput.value && {
                secrets: {
                  ssl: logstashEnableSSLInput.value ? {
                    key: sslKeySecretInput.value
                  } : undefined
                }
              }),
              proxy_id: proxyIdValue,
              ...shipperParams
            };
          case _constants.outputType.RemoteElasticsearch:
            let secrets;
            if (!serviceTokenInput.value && serviceTokenSecretInput.value) {
              secrets = {
                service_token: serviceTokenSecretInput.value
              };
            }
            if (!sslKeyInput.value && sslKeySecretInput.value) {
              var _secrets3;
              secrets = {
                ...((_secrets3 = secrets) !== null && _secrets3 !== void 0 ? _secrets3 : {}),
                ssl: {
                  key: sslKeySecretInput.value
                }
              };
            }
            return {
              name: nameInput.value,
              type: _constants.outputType.RemoteElasticsearch,
              hosts: elasticsearchUrlInput.value,
              is_default: defaultOutputInput.value,
              is_default_monitoring: defaultMonitoringOutputInput.value,
              preset: presetInput.value,
              config_yaml: additionalYamlConfigInput.value,
              service_token: serviceTokenInput.value || undefined,
              kibana_api_key: kibanaAPIKeyInput.value || undefined,
              ...(secrets ? {
                secrets
              } : {}),
              sync_integrations: syncIntegrationsInput.value,
              kibana_url: kibanaURLInput.value || null,
              sync_uninstalled_integrations: syncUninstalledIntegrationsInput.value,
              proxy_id: proxyIdValue,
              ...shipperParams,
              ssl: {
                certificate: sslCertificateInput.value,
                key: sslKeyInput.value || undefined,
                certificate_authorities: sslCertificateAuthoritiesInput.value.filter(val => val !== '')
              }
            };
          case _constants.outputType.Elasticsearch:
          default:
            return {
              name: nameInput.value,
              type: _constants.outputType.Elasticsearch,
              hosts: elasticsearchUrlInput.value,
              is_default: defaultOutputInput.value,
              is_default_monitoring: defaultMonitoringOutputInput.value,
              preset: presetInput.value,
              config_yaml: additionalYamlConfigInput.value,
              ca_trusted_fingerprint: caTrustedFingerprintInput.value,
              proxy_id: proxyIdValue,
              ...shipperParams,
              ssl: {
                certificate: sslCertificateInput.value,
                key: sslKeyInput.value || undefined,
                certificate_authorities: sslCertificateAuthoritiesInput.value.filter(val => val !== '')
              },
              ...(!sslKeyInput.value && sslKeySecretInput.value && {
                secrets: {
                  ssl: {
                    key: sslKeySecretInput.value
                  }
                }
              })
            };
        }
      })();
      if (output) {
        // Update
        if (!(await (0, _confirm_update.confirmUpdate)(output, confirm))) {
          setIsloading(false);
          return;
        }
        const res = await (0, _hooks.sendPutOutput)(output.id, payload);
        if (res.error) {
          throw res.error;
        }
      } else {
        // Create
        const res = await (0, _hooks.sendPostOutput)(payload);
        if (res.error) {
          throw res.error;
        }
      }
      onSucess();
      setIsloading(false);
    } catch (err) {
      setIsloading(false);
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.settings.outputForm.errorToastTitle', {
          defaultMessage: 'Error while saving output'
        })
      });
    }
  }, [validate, isShipperDisabled, showExperimentalShipperOptions, proxyIdInput.value, output, onSucess, memQueueEvents.value, queueFlushTimeout.value, maxBatchBytes.value, diskQueueEnabledInput.value, diskQueuePathInput.value, diskQueueMaxSizeInput.value, diskQueueEncryptionEnabled.value, diskQueueCompressionEnabled.value, compressionLevelInput.value, loadBalanceEnabledInput.value, typeInput.value, kafkaSslCertificateAuthoritiesInput.value, kafkaSslKeyInput, kafkaSslKeySecretInput, kafkaAuthPasswordInput, kafkaAuthPasswordSecretInput, nameInput.value, kafkaHostsInput.value, defaultOutputInput.value, defaultMonitoringOutputInput.value, additionalYamlConfigInput.value, kafkaConnectionTypeInput.value, kafkaAuthMethodInput.value, kafkaSslCertificateInput.value, kafkaVerificationModeInput.value, kafkaClientIdInput.value, kafkaVersionInput.value, kafkaKeyInput.value, kafkaCompressionInput.value, kafkaCompressionCodecInput.value, kafkaCompressionLevelInput.value, kafkaAuthUsernameInput.value, kafkaSaslMechanismInput.value, kafkaPartitionTypeInput.value, kafkaPartitionTypeRandomInput.value, kafkaPartitionTypeRoundRobinInput.value, kafkaPartitionTypeHashInput.value, kafkaTopicsInput.value, kafkaStaticTopicInput.value, kafkaDynamicTopicInput.value, kafkaHeadersInput.value, kafkaBrokerTimeoutInput.value, kafkaBrokerReachabilityTimeoutInput.value, kafkaBrokerAckReliabilityInput.value, logstashEnableSSLInput.value, logstashHostsInput.value, sslCertificateInput.value, sslKeyInput.value, sslCertificateAuthoritiesInput.value, sslKeySecretInput.value, elasticsearchUrlInput.value, presetInput.value, serviceTokenInput.value, serviceTokenSecretInput.value, kibanaAPIKeyInput.value, syncIntegrationsInput.value, syncUninstalledIntegrationsInput.value, kibanaURLInput.value, caTrustedFingerprintInput.value, confirm, notifications.toasts]);
  return {
    inputs,
    submit,
    isLoading,
    hasEncryptedSavedObjectConfigured,
    isShipperEnabled: !isShipperDisabled,
    isDisabled: isLoading || output && !hasChanged || isLogstash && !hasEncryptedSavedObjectConfigured
  };
}