"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRerankCommand = void 0;
var _builder = require("../../builder");
var _utils = require("../../visitor/utils");
var _factories = require("../factories");
var _helpers = require("../helpers");
var _walkers = require("../walkers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const parserFieldsFromCtx = ctx => {
  var _ctx$stop$stop, _ctx$stop;
  const min = ctx.start.start;
  const max = (_ctx$stop$stop = (_ctx$stop = ctx.stop) === null || _ctx$stop === void 0 ? void 0 : _ctx$stop.stop) !== null && _ctx$stop$stop !== void 0 ? _ctx$stop$stop : ctx.start.stop;
  return {
    text: ctx.getText(),
    location: {
      min,
      max
    },
    incomplete: Boolean(ctx.exception)
  };
};
const visitRerankField = ctx => {
  const columnCtx = ctx.qualifiedName();
  const column = (0, _factories.createColumn)(columnCtx);
  const assignCtx = ctx.ASSIGN();
  if (assignCtx) {
    const booleanExpression = (0, _utils.firstItem)((0, _walkers.collectBooleanExpression)(ctx.booleanExpression()));
    const assignment = _builder.Builder.expression.func.binary('=', [column, booleanExpression], {}, parserFieldsFromCtx(ctx));
    return assignment;
  }
  return column;
};
const visitRerankFields = ctx => {
  const ast = [];
  if (!ctx) {
    return ast;
  }
  for (const fieldCtx of ctx.rerankField_list()) {
    const field = visitRerankField(fieldCtx);
    ast.push(field);
  }
  return ast;
};
const createRerankCommand = ctx => {
  const query = (0, _utils.resolveItem)((0, _walkers.getConstant)(ctx._queryText));
  const fieldsCtx = ctx.rerankFields();
  const fields = visitRerankFields(fieldsCtx);

  /**
   * @todo Parse out correctly "inference command options" once grammar for the RERANK
   * command is stabilized. Currently, we comment out `inferenceId` parsing to get
   * the latest grammar merged, while RERANK command will not make it to 9.1 anyways.
   */

  // const inferenceIdCtx = ctx._inferenceId;
  const inferenceCommandOptions = ctx.inferenceCommandOptions();
  // const maybeInferenceId = inferenceIdCtx ? createIdentifierOrParam(inferenceIdCtx) : undefined;
  // const inferenceId = maybeInferenceId ?? Builder.identifier('', { incomplete: true });

  const inferenceId = _builder.Builder.identifier('', {
    incomplete: true
  });
  const command = (0, _factories.createCommand)('rerank', ctx, {
    query,
    fields,
    inferenceId
  });
  const onCtx = ctx.ON();
  const optionOn = _builder.Builder.option({
    name: 'on',
    args: fields
  }, onCtx && fieldsCtx ? {
    location: (0, _helpers.getPosition)(onCtx.symbol, fieldsCtx.stop)
  } : undefined);
  const withCtx = ctx.WITH();
  const optionWith = _builder.Builder.option({
    name: 'with',
    args: [inferenceId]
  }, withCtx && inferenceCommandOptions ? {
    location: (0, _helpers.getPosition)(withCtx.symbol, inferenceCommandOptions.stop)
  } : undefined);
  if (query.incomplete || inferenceId.incomplete || !onCtx) {
    command.incomplete = true;
  }
  command.args.push(query, optionOn, optionWith);
  return command;
};
exports.createRerankCommand = createRerankCommand;