"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana = require("../../../shared/kibana");
var _routes = require("../../routes");
var _page_template = require("../layout/page_template");
var _add_indices_flyout = require("./add_indices_flyout");
var _search_application_indices = require("./search_application_indices");
var _search_application_indices_logic = require("./search_application_indices_logic");
var _search_application_schema = require("./search_application_schema");
var _search_application_view_logic = require("./search_application_view_logic");
require("./search_application_layout.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pageTitle = _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.content.pageTitle', {
  defaultMessage: 'Content'
});
const INDICES_TAB_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.content.indicesTabTitle', {
  defaultMessage: 'Indices'
});
const SCHEMA_TAB_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.content.schemaTabTitle', {
  defaultMessage: 'Schema'
});
const getTabBreadCrumb = tabId => {
  switch (tabId) {
    case _routes.SearchApplicationContentTabs.INDICES:
      return INDICES_TAB_TITLE;
    case _routes.SearchApplicationContentTabs.SCHEMA:
      return SCHEMA_TAB_TITLE;
    default:
      return tabId;
  }
};
const SearchApplicationContent = () => {
  const {
    searchApplicationName,
    isLoadingSearchApplication,
    hasSchemaConflicts
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    addIndicesFlyoutOpen
  } = (0, _kea.useValues)(_search_application_indices_logic.SearchApplicationIndicesLogic);
  const {
    closeAddIndicesFlyout,
    openAddIndicesFlyout
  } = (0, _kea.useActions)(_search_application_indices_logic.SearchApplicationIndicesLogic);
  const {
    contentTabId = _routes.SearchApplicationContentTabs.INDICES
  } = (0, _reactRouterDom.useParams)();
  const onTabClick = tab => () => {
    _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONTENT_PATH, {
      contentTabId: tab,
      searchApplicationName
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchApplicationsPageTemplate, {
    pageChrome: [searchApplicationName, pageTitle, getTabBreadCrumb(contentTabId)],
    pageViewTelemetry: _routes.SearchApplicationViewTabs.CONTENT,
    isLoading: isLoadingSearchApplication,
    pageHeader: {
      bottomBorder: false,
      breadcrumbs: [{
        color: 'primary',
        onClick: () => _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_PATH, {
          searchApplicationName
        })),
        text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "s",
          type: "arrowLeft"
        }), " ", searchApplicationName)
      }],
      className: 'searchApplicationHeaderBackgroundColor',
      pageTitle,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-telemetry-id": "entSearchApplications-indices-addNewIndices",
        "data-test-subj": "search-application-add-new-indices-btn",
        iconType: "plusInCircle",
        fill: true,
        onClick: openAddIndicesFlyout
      }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.addNewIndicesButton', {
        defaultMessage: 'Add new indices'
      }))],
      tabs: [{
        isSelected: contentTabId === _routes.SearchApplicationContentTabs.INDICES,
        label: INDICES_TAB_TITLE,
        onClick: onTabClick(_routes.SearchApplicationContentTabs.INDICES)
      }, {
        isSelected: contentTabId === _routes.SearchApplicationContentTabs.SCHEMA,
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center"
        }, hasSchemaConflicts && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "warning",
          color: "danger"
        }), SCHEMA_TAB_TITLE),
        onClick: onTabClick(_routes.SearchApplicationContentTabs.SCHEMA)
      }]
    },
    searchApplicationName: searchApplicationName,
    hasSchemaConflicts: hasSchemaConflicts
  }, contentTabId === _routes.SearchApplicationContentTabs.INDICES && /*#__PURE__*/_react.default.createElement(_search_application_indices.SearchApplicationIndices, null), contentTabId === _routes.SearchApplicationContentTabs.SCHEMA && /*#__PURE__*/_react.default.createElement(_search_application_schema.SearchApplicationSchema, null), addIndicesFlyoutOpen && /*#__PURE__*/_react.default.createElement(_add_indices_flyout.AddIndicesFlyout, {
    onClose: closeAddIndicesFlyout
  }));
};
exports.SearchApplicationContent = SearchApplicationContent;