"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetAISearchChromeSearchDocsSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SetAISearchChromeSearchDocsSection = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 4
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.aiSearchDocsSection.title",
  defaultMessage: "Dive deeper with AI Search"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.aiSearchDocsSection.description",
  defaultMessage: "To learn more about how to get started and test these tools with concrete examples, visit {searchLab}.",
  values: {
    searchLab: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-telemetry-id": "entSearch-aiSearch-documentation-searchLabsLink",
      target: "_blank",
      href: _doc_links.docLinks.searchLabs,
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.aiSearchDocsSection.description.searchLabsLinkText', {
      defaultMessage: 'Search Labs'
    }))
  }
})))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 6
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.aiSearchDocsSection.learn.title",
  defaultMessage: "Learn"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.aiSearchDocsSection.learn.description",
  defaultMessage: "The {searchLabsRepo} has notebooks, sample apps, and resources.",
  values: {
    searchLabsRepo: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-telemetry-id": "entSearch-aiSearch-documentation-searchLabsRepoLink",
      target: "_blank",
      href: _doc_links.docLinks.searchLabsRepo,
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.aiSearchDocsSection.learn.searchLabsRepoLinkText', {
      defaultMessage: 'Search Labs Github repo'
    }))
  }
}))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.aiSearchDocsSection.doc.title",
  defaultMessage: "Docs"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.aiSearchDocsSection.doc.description",
  defaultMessage: "Visit the {aiSearchDoc}.",
  values: {
    aiSearchDoc: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-telemetry-id": "entSearch-aiSearch-documentation-aiSearchDocLink",
      target: "_blank",
      href: _doc_links.docLinks.aiSearchDoc,
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.aiSearchDocsSection.doc.aiSearchDocLinkText', {
      defaultMessage: 'Elastic documentation'
    }))
  }
}))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.aiSearchDocsSection.help.title",
  defaultMessage: "Help"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.aiSearchDocsSection.help.description",
  defaultMessage: "Need help? Check out the {discussForum}!",
  values: {
    discussForum: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-telemetry-id": "entSearch-aiSearch-documentation-aiSearchHelpLink",
      target: "_blank",
      href: _doc_links.docLinks.aiSearchHelp,
      external: false
    }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.aiSearchDocsSection.help.helpLinkText', {
      defaultMessage: 'discuss forum or Elastic community Slack'
    }))
  }
}))))))))));
exports.SetAISearchChromeSearchDocsSection = SetAISearchChromeSearchDocsSection;